/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.arguments.compound.CompoundArgument;
import cloud.commandframework.arguments.compound.FlagArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.AmbiguousNodeException;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoCommandInLeafException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.OrPermission;
import cloud.commandframework.types.tuples.Pair;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandTree<C> {
    private final Object commandLock = new Object();
    private final Node<CommandArgument<C, ?>> internalTree = new Node(null);
    private final CommandManager<C> commandManager;

    private CommandTree(@NonNull CommandManager<C> commandManager) {
        this.commandManager = commandManager;
    }

    public static <C> @NonNull CommandTree<C> newTree(@NonNull CommandManager<C> commandManager) {
        return new CommandTree<C>(commandManager);
    }

    public @NonNull Pair<@Nullable Command<C>, @Nullable Exception> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> args) {
        Command<C> command;
        Pair<@Nullable Command<C>, @Nullable Exception> pair = this.parseCommand(new ArrayList(), commandContext, args, this.internalTree);
        if (pair.getFirst() != null && (command = pair.getFirst()).getSenderType().isPresent() && !command.getSenderType().get().isAssignableFrom(commandContext.getSender().getClass())) {
            return Pair.of(null, new InvalidCommandSenderException(commandContext.getSender(), command.getSenderType().get(), Collections.emptyList()));
        }
        return pair;
    }

    private @NonNull Pair<@Nullable Command<C>, @Nullable Exception> parseCommand(@NonNull List<@NonNull CommandArgument<C, ?>> parsedArguments, @NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> commandQueue, @NonNull Node<@Nullable CommandArgument<C, ?>> root) {
        CommandPermission permission = this.isPermitted(commandContext.getSender(), root);
        if (permission != null) {
            return Pair.of(null, new NoPermissionException(permission, commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
        }
        Pair<@Nullable Command<C>, @Nullable Exception> parsedChild = this.attemptParseUnambiguousChild(parsedArguments, commandContext, root, commandQueue);
        if (parsedChild.getFirst() != null || parsedChild.getSecond() != null) {
            return parsedChild;
        }
        if (((Node)root).children.isEmpty()) {
            if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                if (commandQueue.isEmpty()) {
                    return Pair.of(this.cast(root.getValue().getOwningCommand()), null);
                }
                return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
        }
        Iterator<Node<CommandArgument<C, ?>>> childIterator = root.getChildren().iterator();
        if (childIterator.hasNext()) {
            while (childIterator.hasNext()) {
                Node<CommandArgument<C, ?>> child = childIterator.next();
                if (child.getValue() == null) continue;
                CommandArgument<C, ?> argument = child.getValue();
                CommandContext.ArgumentTiming argumentTiming = commandContext.createTiming(argument);
                argumentTiming.setStart(System.nanoTime());
                ArgumentParseResult<?> result = argument.getParser().parse(commandContext, commandQueue);
                argumentTiming.setEnd(System.nanoTime(), result.getFailure().isPresent());
                if (!result.getParsedValue().isPresent()) continue;
                parsedArguments.add(child.getValue());
                return this.parseCommand(parsedArguments, commandContext, commandQueue, child);
            }
        }
        if (root.equals(this.internalTree)) {
            return Pair.of(null, new NoSuchCommandException(commandContext.getSender(), this.getChain(root).stream().map(Node::getValue).collect(Collectors.toList()), this.stringOrEmpty(commandQueue.peek())));
        }
        if (root.getValue() != null && root.getValue().getOwningCommand() != null && commandQueue.isEmpty()) {
            Command<C> command = root.getValue().getOwningCommand();
            if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            return Pair.of(root.getValue().getOwningCommand(), null);
        }
        return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
    }

    private @NonNull Pair<@Nullable Command<C>, @Nullable Exception> attemptParseUnambiguousChild(@NonNull List<@NonNull CommandArgument<C, ?>> parsedArguments, @NonNull CommandContext<C> commandContext, @NonNull Node<@Nullable CommandArgument<C, ?>> root, @NonNull Queue<String> commandQueue) {
        List<Node<CommandArgument<C, ?>>> children = root.getChildren();
        if (children.size() == 1 && !(children.get(0).getValue() instanceof StaticArgument)) {
            Node<CommandArgument<C, ?>> child = children.get(0);
            CommandPermission permission = this.isPermitted(commandContext.getSender(), child);
            if (!commandQueue.isEmpty() && permission != null) {
                return Pair.of(null, new NoPermissionException(permission, commandContext.getSender(), this.getChain(child).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
            }
            if (child.getValue() != null) {
                if (commandQueue.isEmpty()) {
                    if (child.getValue().hasDefaultValue()) {
                        commandQueue.add(child.getValue().getDefaultValue());
                    } else {
                        if (!child.getValue().isRequired()) {
                            if (child.getValue().getOwningCommand() == null) {
                                Node<CommandArgument<C, ?>> node2 = child;
                                while (!node2.isLeaf()) {
                                    if ((node2 = node2.getChildren().get(0)).getValue() == null || node2.getValue().getOwningCommand() == null) continue;
                                    child.getValue().setOwningCommand(node2.getValue().getOwningCommand());
                                }
                            }
                            return Pair.of(child.getValue().getOwningCommand(), null);
                        }
                        if (child.isLeaf()) {
                            if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                                Command<C> command = root.getValue().getOwningCommand();
                                if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                                    return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                                }
                                return Pair.of(command, null);
                            }
                            return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(Objects.requireNonNull(child.getValue().getOwningCommand()).getArguments(), child), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                        }
                        if (root.getValue() != null && root.getValue().getOwningCommand() != null) {
                            Command<C> command = root.getValue().getOwningCommand();
                            if (!this.getCommandManager().hasPermission(commandContext.getSender(), command.getCommandPermission())) {
                                return Pair.of(null, new NoPermissionException(command.getCommandPermission(), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                            }
                            return Pair.of(command, null);
                        }
                        return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(parsedArguments, root), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                    }
                }
                CommandArgument<C, ?> argument = child.getValue();
                CommandContext.ArgumentTiming argumentTiming = commandContext.createTiming(argument);
                argumentTiming.setStart(System.nanoTime());
                ArgumentParseResult<Boolean> preParseResult = child.getValue().preprocess(commandContext, commandQueue);
                ArgumentParseResult<Boolean> result = !preParseResult.getFailure().isPresent() && preParseResult.getParsedValue().orElse(false) != false ? argument.getParser().parse(commandContext, commandQueue) : preParseResult;
                argumentTiming.setEnd(System.nanoTime(), result.getFailure().isPresent());
                if (result.getParsedValue().isPresent()) {
                    commandContext.store(child.getValue().getName(), result.getParsedValue().get());
                    if (child.isLeaf()) {
                        if (commandQueue.isEmpty()) {
                            return Pair.of(this.cast(child.getValue().getOwningCommand()), null);
                        }
                        return Pair.of(null, new InvalidSyntaxException(this.commandManager.getCommandSyntaxFormatter().apply(parsedArguments, child), commandContext.getSender(), this.getChain(root).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                    }
                    parsedArguments.add(child.getValue());
                    return this.parseCommand(parsedArguments, commandContext, commandQueue, child);
                }
                if (result.getFailure().isPresent()) {
                    return Pair.of(null, new ArgumentParseException(result.getFailure().get(), commandContext.getSender(), this.getChain(child).stream().filter(node -> node.getValue() != null).map(Node::getValue).collect(Collectors.toList())));
                }
            }
        }
        return Pair.of(null, null);
    }

    public @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> context, @NonNull Queue<@NonNull String> commandQueue) {
        return this.getSuggestions(context, commandQueue, this.internalTree);
    }

    private @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> commandQueue, @NonNull Node<@Nullable CommandArgument<C, ?>> root) {
        if (this.isPermitted(commandContext.getSender(), root) != null) {
            return Collections.emptyList();
        }
        List<Node<CommandArgument<C, ?>>> children = root.getChildren();
        if (children.size() == 1 && !(children.get(0).getValue() instanceof StaticArgument)) {
            Node<CommandArgument<C, ?>> child = children.get(0);
            if (child.getValue() instanceof CompoundArgument) {
                CompoundArgument compoundArgument = (CompoundArgument)child.getValue();
                int requiredArguments = compoundArgument.getParserTuple().getSize();
                if (commandQueue.size() <= requiredArguments) {
                    for (int i = 0; i < requiredArguments - 1 && commandQueue.size() > 1; ++i) {
                        commandQueue.remove();
                        commandContext.store("__parsing_argument__", i + 2);
                    }
                }
            } else if (child.getValue() instanceof FlagArgument) {
                while (commandQueue.size() > 1) {
                    commandContext.store("__last_flag__", commandQueue.remove());
                }
            } else if (child.getValue() != null && GenericTypeReflector.erase((Type)child.getValue().getValueType().getType()).isArray()) {
                while (commandQueue.size() > 1) {
                    commandQueue.remove();
                }
            } else if (child.getValue() != null && commandQueue.size() <= child.getValue().getParser().getRequestedArgumentCount()) {
                for (int i = 0; i < child.getValue().getParser().getRequestedArgumentCount() - 1 && commandQueue.size() > 1; ++i) {
                    commandContext.store(String.format("%s_%d", child.getValue().getName(), i), commandQueue.remove());
                }
            }
            if (child.getValue() != null) {
                if (commandQueue.isEmpty()) {
                    return Collections.emptyList();
                }
                if (child.isLeaf() && commandQueue.size() < 2) {
                    return child.getValue().getSuggestionsProvider().apply(commandContext, commandQueue.peek());
                }
                if (child.isLeaf()) {
                    if (child.getValue() instanceof CompoundArgument) {
                        String last = (String)((LinkedList)commandQueue).getLast();
                        return child.getValue().getSuggestionsProvider().apply(commandContext, last);
                    }
                    return Collections.emptyList();
                }
                if (commandQueue.peek().isEmpty()) {
                    return child.getValue().getSuggestionsProvider().apply(commandContext, commandQueue.remove());
                }
                ArgumentParseResult<Boolean> preParseResult = child.getValue().preprocess(commandContext, commandQueue);
                if (preParseResult.getFailure().isPresent() || !preParseResult.getParsedValue().orElse(false).booleanValue()) {
                    String value = commandQueue.peek() == null ? "" : commandQueue.peek();
                    return child.getValue().getSuggestionsProvider().apply(commandContext, value);
                }
                ArgumentParseResult<?> result = child.getValue().getParser().parse(commandContext, commandQueue);
                if (result.getParsedValue().isPresent()) {
                    commandContext.store(child.getValue().getName(), result.getParsedValue().get());
                    return this.getSuggestions(commandContext, commandQueue, child);
                }
                if (result.getFailure().isPresent()) {
                    String value = commandQueue.peek() == null ? "" : commandQueue.peek();
                    return child.getValue().getSuggestionsProvider().apply(commandContext, value);
                }
            }
        }
        if (children.isEmpty() || commandQueue.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<Node<CommandArgument<C, ?>>> childIterator = root.getChildren().iterator();
        if (childIterator.hasNext()) {
            while (childIterator.hasNext()) {
                ArgumentParseResult<?> result;
                Node<CommandArgument<C, ?>> child = childIterator.next();
                if (child.getValue() == null || !(result = child.getValue().getParser().parse(commandContext, commandQueue)).getParsedValue().isPresent()) continue;
                return this.getSuggestions(commandContext, commandQueue, child);
            }
            if (commandQueue.size() > 1) {
                return Collections.emptyList();
            }
        }
        LinkedList<String> suggestions = new LinkedList<String>();
        for (Node<CommandArgument<C, ?>> argument : root.getChildren()) {
            if (argument.getValue() == null || this.isPermitted(commandContext.getSender(), argument) != null) continue;
            List<String> suggestionsToAdd = argument.getValue().getSuggestionsProvider().apply(commandContext, this.stringOrEmpty(commandQueue.peek()));
            suggestions.addAll(suggestionsToAdd);
        }
        return suggestions;
    }

    private @NonNull String stringOrEmpty(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCommand(@NonNull Command<C> command) {
        Object object = this.commandLock;
        synchronized (object) {
            Node node = this.internalTree;
            for (CommandArgument<C, ?> argument : command.getArguments()) {
                Node tempNode = node.getChild(argument);
                if (tempNode == null) {
                    tempNode = node.addChild(argument);
                } else if (argument instanceof StaticArgument && tempNode.getValue() != null) {
                    for (String alias : ((StaticArgument)argument).getAliases()) {
                        ((StaticArgument)tempNode.getValue()).registerAlias(alias);
                    }
                }
                if (node.children.size() > 0) {
                    node.children.sort(Comparator.comparing(Node::getValue));
                }
                tempNode.setParent(node);
                node = tempNode;
            }
            if (node.getValue() != null) {
                if (node.getValue().getOwningCommand() != null) {
                    throw new IllegalStateException(String.format("Duplicate command chains detected. Node '%s' already has an owning command (%s)", node.toString(), ((CommandArgument)node.getValue()).getOwningCommand().toString()));
                }
                node.getValue().setOwningCommand(command);
            }
            this.verifyAndRegister();
        }
    }

    private @Nullable CommandPermission isPermitted(@NonNull C sender, @NonNull Node<@Nullable CommandArgument<C, ?>> node) {
        CommandPermission permission = (CommandPermission)((Node)node).nodeMeta.get("permission");
        if (permission != null) {
            return this.commandManager.hasPermission(sender, permission) ? null : permission;
        }
        if (node.isLeaf()) {
            return this.commandManager.hasPermission(sender, Objects.requireNonNull(Objects.requireNonNull((CommandArgument)((Node)node).value, "node.value").getOwningCommand(), "owning command").getCommandPermission()) ? null : Objects.requireNonNull(((CommandArgument)((Node)node).value).getOwningCommand(), "owning command").getCommandPermission();
        }
        LinkedList<CommandPermission> missingPermissions = new LinkedList<CommandPermission>();
        for (Node<CommandArgument<C, ?>> child : node.getChildren()) {
            CommandPermission check = this.isPermitted(sender, child);
            if (check == null) {
                return null;
            }
            missingPermissions.add(check);
        }
        return OrPermission.of(missingPermissions);
    }

    public void verifyAndRegister() {
        ((Node)this.internalTree).children.stream().map(Node::getValue).forEach(commandArgument -> {
            if (!(commandArgument instanceof StaticArgument)) {
                throw new IllegalStateException("Top level command argument cannot be a variable");
            }
        });
        this.checkAmbiguity(this.internalTree);
        this.getLeaves(this.internalTree).forEach(leaf -> {
            if (leaf.getOwningCommand() == null) {
                throw new NoCommandInLeafException((CommandArgument<?, ?>)leaf);
            }
            Command owningCommand = leaf.getOwningCommand();
            this.commandManager.getCommandRegistrationHandler().registerCommand(owningCommand);
        });
        this.getLeavesRaw(this.internalTree).forEach(node -> {
            CommandPermission commandPermission = ((CommandArgument)node.getValue()).getOwningCommand().getCommandPermission();
            ((Node)node).nodeMeta.put("permission", commandPermission);
            List<Node<CommandArgument<C, ?>>> chain = this.getChain((Node<CommandArgument<C, ?>>)node);
            Collections.reverse(chain);
            chain = chain.subList(1, chain.size());
            for (Node<CommandArgument<C, ?>> commandArgumentNode : chain) {
                CommandPermission existingPermission = (CommandPermission)((Node)commandArgumentNode).nodeMeta.get("permission");
                CommandPermission permission = existingPermission != null ? OrPermission.of(Arrays.asList(commandPermission, existingPermission)) : commandPermission;
                if (commandArgumentNode.getValue() != null && commandArgumentNode.getValue().getOwningCommand() != null) {
                    Command<C> command = commandArgumentNode.getValue().getOwningCommand();
                    permission = this.getCommandManager().getSetting(CommandManager.ManagerSettings.ENFORCE_INTERMEDIARY_PERMISSIONS) ? command.getCommandPermission() : OrPermission.of(Arrays.asList(permission, command.getCommandPermission()));
                }
                ((Node)commandArgumentNode).nodeMeta.put("permission", permission);
            }
        });
    }

    private void checkAmbiguity(@NonNull Node<@Nullable CommandArgument<C, ?>> node) throws AmbiguousNodeException {
        if (node.isLeaf()) {
            return;
        }
        int size = ((Node)node).children.size();
        for (Node child : ((Node)node).children) {
            if (child.getValue() == null || ((CommandArgument)child.getValue()).isRequired() || size <= 1) continue;
            throw new AmbiguousNodeException(node.getValue(), (CommandArgument)child.getValue(), node.getChildren().stream().filter(n -> n.getValue() != null).map(Node::getValue).collect(Collectors.toList()));
        }
        ((Node)node).children.forEach(this::checkAmbiguity);
    }

    private @NonNull List<@NonNull Node<@Nullable CommandArgument<C, ?>>> getLeavesRaw(@NonNull Node<@Nullable CommandArgument<C, ?>> node) {
        LinkedList leaves = new LinkedList();
        if (node.isLeaf()) {
            if (node.getValue() != null) {
                leaves.add(node);
            }
        } else {
            ((Node)node).children.forEach(child -> leaves.addAll(this.getLeavesRaw((Node<CommandArgument<C, ?>>)child)));
        }
        return leaves;
    }

    private @NonNull List<@NonNull CommandArgument<C, ?>> getLeaves(@NonNull Node<@NonNull CommandArgument<C, ?>> node) {
        LinkedList leaves = new LinkedList();
        if (node.isLeaf()) {
            if (node.getValue() != null) {
                leaves.add(node.getValue());
            }
        } else {
            ((Node)node).children.forEach(child -> leaves.addAll(this.getLeaves((Node<CommandArgument<C, ?>>)child)));
        }
        return leaves;
    }

    private @NonNull List<@NonNull Node<@Nullable CommandArgument<C, ?>>> getChain(@Nullable Node<@Nullable CommandArgument<C, ?>> end) {
        LinkedList chain = new LinkedList();
        for (Node<CommandArgument<C, ?>> tail = end; tail != null; tail = tail.getParent()) {
            chain.add(tail);
        }
        Collections.reverse(chain);
        return chain;
    }

    private @Nullable Command<C> cast(@Nullable Command<C> command) {
        return command;
    }

    public @NonNull Collection<@NonNull Node<@Nullable CommandArgument<C, ?>>> getRootNodes() {
        return this.internalTree.getChildren();
    }

    public @Nullable Node<@Nullable CommandArgument<C, ?>> getNamedNode(@Nullable String name) {
        for (Node<CommandArgument<C, ?>> node : this.getRootNodes()) {
            if (node.getValue() == null || !(node.getValue() instanceof StaticArgument)) continue;
            StaticArgument staticArgument = (StaticArgument)node.getValue();
            for (String alias : staticArgument.getAliases()) {
                if (!alias.equalsIgnoreCase(name)) continue;
                return node;
            }
        }
        return null;
    }

    public @NonNull CommandManager<C> getCommandManager() {
        return this.commandManager;
    }

    public static final class Node<T> {
        private final Map<String, Object> nodeMeta = new HashMap<String, Object>();
        private final List<Node<T>> children = new LinkedList<Node<T>>();
        private final T value;
        private Node<T> parent;

        private Node(@Nullable T value) {
            this.value = value;
        }

        public @NonNull List<@NonNull Node<@Nullable T>> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        private @NonNull Node<@Nullable T> addChild(@NonNull T child) {
            Node<T> node = new Node<T>(child);
            this.children.add(node);
            return node;
        }

        private @Nullable Node<@Nullable T> getChild(@NonNull T type) {
            for (Node<T> child : this.children) {
                if (!type.equals(child.getValue())) continue;
                return child;
            }
            return null;
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public @NonNull Map<@NonNull String, @NonNull Object> getNodeMeta() {
            return this.nodeMeta;
        }

        public @Nullable T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.getValue(), node.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }

        public @Nullable Node<@Nullable T> getParent() {
            return this.parent;
        }

        public void setParent(@Nullable Node<@Nullable T> parent) {
            this.parent = parent;
        }

        public String toString() {
            return "Node{value=" + this.value + '}';
        }
    }
}

