/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.Command;
import cloud.commandframework.CommandHelpHandler;
import cloud.commandframework.CommandTree;
import cloud.commandframework.Description;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.CommandSuggestionEngine;
import cloud.commandframework.arguments.CommandSyntaxFormatter;
import cloud.commandframework.arguments.DelegatingCommandSuggestionEngineFactory;
import cloud.commandframework.arguments.StandardCommandSyntaxFormatter;
import cloud.commandframework.arguments.flags.CommandFlag;
import cloud.commandframework.arguments.parser.ParserRegistry;
import cloud.commandframework.arguments.parser.StandardParserRegistry;
import cloud.commandframework.captions.CaptionRegistry;
import cloud.commandframework.captions.SimpleCaptionRegistryFactory;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.context.CommandContextFactory;
import cloud.commandframework.context.StandardCommandContextFactory;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.execution.CommandResult;
import cloud.commandframework.execution.CommandSuggestionProcessor;
import cloud.commandframework.execution.FilteringCommandSuggestionProcessor;
import cloud.commandframework.execution.postprocessor.AcceptingCommandPostprocessor;
import cloud.commandframework.execution.postprocessor.CommandPostprocessingContext;
import cloud.commandframework.execution.postprocessor.CommandPostprocessor;
import cloud.commandframework.execution.preprocessor.AcceptingCommandPreprocessor;
import cloud.commandframework.execution.preprocessor.CommandPreprocessingContext;
import cloud.commandframework.execution.preprocessor.CommandPreprocessor;
import cloud.commandframework.internal.CommandInputTokenizer;
import cloud.commandframework.internal.CommandRegistrationHandler;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.OrPermission;
import cloud.commandframework.permission.Permission;
import cloud.commandframework.services.ServicePipeline;
import cloud.commandframework.services.State;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CommandManager<C> {
    private final Map<Class<? extends Exception>, BiConsumer<C, ? extends Exception>> exceptionHandlers = new HashMap<Class<? extends Exception>, BiConsumer<C, ? extends Exception>>();
    private final EnumSet<ManagerSettings> managerSettings = EnumSet.of(ManagerSettings.ENFORCE_INTERMEDIARY_PERMISSIONS);
    private final CommandContextFactory<C> commandContextFactory = new StandardCommandContextFactory();
    private final ServicePipeline servicePipeline = ServicePipeline.builder().build();
    private final ParserRegistry<C> parserRegistry = new StandardParserRegistry();
    private final Collection<Command<C>> commands = new LinkedList<Command<C>>();
    private final CommandExecutionCoordinator<C> commandExecutionCoordinator;
    private final CommandTree<C> commandTree;
    private final CommandSuggestionEngine<C> commandSuggestionEngine;
    private CommandSyntaxFormatter<C> commandSyntaxFormatter = new StandardCommandSyntaxFormatter();
    private CommandSuggestionProcessor<C> commandSuggestionProcessor = new FilteringCommandSuggestionProcessor();
    private CommandRegistrationHandler commandRegistrationHandler;
    private CaptionRegistry<C> captionRegistry;

    protected CommandManager(@NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull CommandRegistrationHandler commandRegistrationHandler) {
        this.commandTree = CommandTree.newTree(this);
        this.commandExecutionCoordinator = commandExecutionCoordinator.apply(this.commandTree);
        this.commandRegistrationHandler = commandRegistrationHandler;
        this.commandSuggestionEngine = new DelegatingCommandSuggestionEngineFactory(this).create();
        this.servicePipeline.registerServiceType(new TypeToken<CommandPreprocessor<C>>(){}, new AcceptingCommandPreprocessor());
        this.servicePipeline.registerServiceType(new TypeToken<CommandPostprocessor<C>>(){}, new AcceptingCommandPostprocessor());
        this.captionRegistry = new SimpleCaptionRegistryFactory().create();
    }

    public @NonNull CompletableFuture<CommandResult<C>> executeCommand(@NonNull C commandSender, @NonNull String input) {
        CommandContext<C> context = this.commandContextFactory.create(false, commandSender, this.captionRegistry);
        LinkedList<String> inputQueue = new CommandInputTokenizer(input).tokenize();
        try {
            if (this.preprocessContext(context, inputQueue) == State.ACCEPTED) {
                return this.commandExecutionCoordinator.coordinateExecution(context, inputQueue);
            }
        }
        catch (Exception e) {
            CompletableFuture<CommandResult<C>> future = new CompletableFuture<CommandResult<C>>();
            future.completeExceptionally(e);
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    public @NonNull List<@NonNull String> suggest(@NonNull C commandSender, @NonNull String input) {
        CommandContext<C> context = this.commandContextFactory.create(true, commandSender, this.captionRegistry);
        return this.commandSuggestionEngine.getSuggestions(context, input);
    }

    public @NonNull CommandManager<C> command(@NonNull Command<C> command) {
        this.commandTree.insertCommand(command);
        this.commands.add(command);
        return this;
    }

    public @NonNull CommandManager<C> command(@NonNull Command.Builder<C> command) {
        return this.command(command.manager(this).build());
    }

    public @NonNull CommandSyntaxFormatter<C> getCommandSyntaxFormatter() {
        return this.commandSyntaxFormatter;
    }

    public void setCommandSyntaxFormatter(@NonNull CommandSyntaxFormatter<C> commandSyntaxFormatter) {
        this.commandSyntaxFormatter = commandSyntaxFormatter;
    }

    public @NonNull CommandRegistrationHandler getCommandRegistrationHandler() {
        return this.commandRegistrationHandler;
    }

    protected final void setCommandRegistrationHandler(@NonNull CommandRegistrationHandler commandRegistrationHandler) {
        this.commandRegistrationHandler = commandRegistrationHandler;
    }

    public boolean hasPermission(@NonNull C sender, @NonNull CommandPermission permission) {
        if (permission.toString().isEmpty()) {
            return true;
        }
        if (permission instanceof Permission) {
            return this.hasPermission(sender, permission.toString());
        }
        for (CommandPermission innerPermission : permission.getPermissions()) {
            boolean hasPermission = this.hasPermission(sender, innerPermission);
            if (!(permission instanceof OrPermission) || !hasPermission) continue;
            return true;
        }
        return false;
    }

    public final @NonNull CaptionRegistry<C> getCaptionRegistry() {
        return this.captionRegistry;
    }

    public final void setCaptionRegistry(@NonNull CaptionRegistry<C> captionRegistry) {
        this.captionRegistry = captionRegistry;
    }

    @Deprecated
    public final void registerDefaultCaptions(@NonNull CaptionRegistry<C> captionRegistry) {
        this.captionRegistry = captionRegistry;
    }

    public abstract boolean hasPermission(@NonNull C var1, @NonNull String var2);

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull Description description, @NonNull CommandMeta meta) {
        return Command.newBuilder(name, meta, description, aliases.toArray(new String[0])).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Collection<String> aliases, @NonNull CommandMeta meta) {
        return Command.newBuilder(name, meta, Description.empty(), aliases.toArray(new String[0])).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, @NonNull Description description, String ... aliases) {
        return Command.newBuilder(name, meta, description, aliases).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull CommandMeta meta, String ... aliases) {
        return Command.newBuilder(name, meta, Description.empty(), aliases).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, @NonNull Description description, String ... aliases) {
        return Command.newBuilder(name, this.createDefaultCommandMeta(), description, aliases).manager(this);
    }

    public @NonNull Command.Builder<C> commandBuilder(@NonNull String name, String ... aliases) {
        return Command.newBuilder(name, this.createDefaultCommandMeta(), Description.empty(), aliases).manager(this);
    }

    public <T> @NonNull CommandArgument.Builder<C, T> argumentBuilder(@NonNull Class<T> type, @NonNull String name) {
        return CommandArgument.ofType(type, name).manager(this);
    }

    public @NonNull CommandFlag.Builder<Void> flagBuilder(@NonNull String name) {
        return CommandFlag.newBuilder(name);
    }

    public @NonNull CommandTree<C> getCommandTree() {
        return this.commandTree;
    }

    public abstract @NonNull CommandMeta createDefaultCommandMeta();

    public void registerCommandPreProcessor(@NonNull CommandPreprocessor<C> processor) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<CommandPreprocessor<C>>(){}, processor, Collections.emptyList());
    }

    public void registerCommandPostProcessor(@NonNull CommandPostprocessor<C> processor) {
        this.servicePipeline.registerServiceImplementation(new TypeToken<CommandPostprocessor<C>>(){}, processor, Collections.emptyList());
    }

    public State preprocessContext(@NonNull CommandContext<C> context, @NonNull LinkedList<@NonNull String> inputQueue) {
        this.servicePipeline.pump(new CommandPreprocessingContext<C>(context, inputQueue)).through(new TypeToken<CommandPreprocessor<C>>(){}).getResult();
        return context.getOptional("__COMMAND_PRE_PROCESSED__").orElse("").isEmpty() ? State.REJECTED : State.ACCEPTED;
    }

    public State postprocessContext(@NonNull CommandContext<C> context, @NonNull Command<C> command) {
        this.servicePipeline.pump(new CommandPostprocessingContext<C>(context, command)).through(new TypeToken<CommandPostprocessor<C>>(){}).getResult();
        return context.getOptional("__COMMAND_POST_PROCESSED__").orElse("").isEmpty() ? State.REJECTED : State.ACCEPTED;
    }

    public @NonNull CommandSuggestionProcessor<C> getCommandSuggestionProcessor() {
        return this.commandSuggestionProcessor;
    }

    public void setCommandSuggestionProcessor(@NonNull CommandSuggestionProcessor<C> commandSuggestionProcessor) {
        this.commandSuggestionProcessor = commandSuggestionProcessor;
    }

    public ParserRegistry<C> getParserRegistry() {
        return this.parserRegistry;
    }

    public final <E extends Exception> @Nullable BiConsumer<@NonNull C, @NonNull E> getExceptionHandler(@NonNull Class<E> clazz) {
        BiConsumer<C, ? extends Exception> consumer = this.exceptionHandlers.get(clazz);
        if (consumer == null) {
            return null;
        }
        return consumer;
    }

    public final <E extends Exception> void registerExceptionHandler(@NonNull Class<E> clazz, @NonNull BiConsumer<@NonNull C, @NonNull E> handler) {
        this.exceptionHandlers.put(clazz, handler);
    }

    public final <E extends Exception> void handleException(@NonNull C sender, @NonNull Class<E> clazz, @NonNull E exception, @NonNull BiConsumer<C, E> defaultHandler) {
        Optional.ofNullable(this.getExceptionHandler(clazz)).orElse(defaultHandler).accept(sender, exception);
    }

    public final @NonNull Collection<@NonNull Command<C>> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public final @NonNull CommandHelpHandler<C> getCommandHelpHandler() {
        return new CommandHelpHandler(this);
    }

    public boolean getSetting(@NonNull ManagerSettings setting) {
        return this.managerSettings.contains((Object)setting);
    }

    public void setSetting(@NonNull ManagerSettings setting, boolean value) {
        if (value) {
            this.managerSettings.add(setting);
        } else {
            this.managerSettings.remove((Object)setting);
        }
    }

    public static enum ManagerSettings {
        ENFORCE_INTERMEDIARY_PERMISSIONS,
        FORCE_SUGGESTION;

    }
}

