/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework;

import cloud.commandframework.CommandManager;
import cloud.commandframework.Description;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.arguments.compound.ArgumentPair;
import cloud.commandframework.arguments.compound.ArgumentTriplet;
import cloud.commandframework.arguments.compound.FlagArgument;
import cloud.commandframework.arguments.flags.CommandFlag;
import cloud.commandframework.execution.CommandExecutionHandler;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.meta.SimpleCommandMeta;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.Permission;
import cloud.commandframework.types.tuples.Pair;
import cloud.commandframework.types.tuples.Triplet;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Command<C> {
    private final Map<@NonNull CommandArgument<C, ?>, @NonNull Description> arguments;
    private final CommandExecutionHandler<C> commandExecutionHandler;
    private final Class<? extends C> senderType;
    private final CommandPermission commandPermission;
    private final CommandMeta commandMeta;

    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this.arguments = Objects.requireNonNull(commandArguments, "Command arguments may not be null");
        if (this.arguments.size() == 0) {
            throw new IllegalArgumentException("At least one command argument is required");
        }
        boolean foundOptional = false;
        for (CommandArgument<C, ?> argument : this.arguments.keySet()) {
            if (argument.getName().isEmpty()) {
                throw new IllegalArgumentException("Argument names may not be empty");
            }
            if (foundOptional && argument.isRequired()) {
                throw new IllegalArgumentException(String.format("Command argument '%s' cannot be placed after an optional argument", argument.getName()));
            }
            if (argument.isRequired()) continue;
            foundOptional = true;
        }
        this.commandExecutionHandler = commandExecutionHandler;
        this.senderType = senderType;
        this.commandPermission = commandPermission;
        this.commandMeta = commandMeta;
    }

    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandMeta commandMeta) {
        this(commandArguments, commandExecutionHandler, senderType, Permission.empty(), commandMeta);
    }

    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(commandArguments, commandExecutionHandler, null, commandPermission, commandMeta);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, @NonNull Description description, String ... aliases) {
        LinkedHashMap<@NonNull StaticArgument<C>, @NonNull Description> map = new LinkedHashMap();
        map.put(StaticArgument.of(commandName, aliases), description);
        return new Builder(null, commandMeta, null, map, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, String ... aliases) {
        LinkedHashMap map = new LinkedHashMap();
        map.put(StaticArgument.of(commandName, aliases), Description.empty());
        return new Builder(null, commandMeta, null, map, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public @NonNull List<CommandArgument<@NonNull C, @NonNull ?>> getArguments() {
        return new ArrayList(this.arguments.keySet());
    }

    public CommandExecutionHandler<@NonNull C> getCommandExecutionHandler() {
        return this.commandExecutionHandler;
    }

    public @NonNull Optional<Class<? extends C>> getSenderType() {
        return Optional.ofNullable(this.senderType);
    }

    public @NonNull CommandPermission getCommandPermission() {
        return this.commandPermission;
    }

    public @NonNull CommandMeta getCommandMeta() {
        return this.commandMeta;
    }

    public @NonNull String getArgumentDescription(@NonNull CommandArgument<C, ?> argument) {
        return this.arguments.get(argument).getDescription();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CommandArgument<C, ?> argument : this.getArguments()) {
            stringBuilder.append(argument.getName()).append(' ');
        }
        String build = stringBuilder.toString();
        return build.substring(0, build.length() - 1);
    }

    public boolean isHidden() {
        return this.getCommandMeta().getOrDefault("hidden", "true").equals("true");
    }

    public static final class Builder<C> {
        private final CommandMeta commandMeta;
        private final Map<CommandArgument<C, ?>, Description> commandArguments;
        private final CommandExecutionHandler<C> commandExecutionHandler;
        private final Class<? extends C> senderType;
        private final CommandPermission commandPermission;
        private final CommandManager<C> commandManager;
        private final Collection<CommandFlag<?>> flags;

        private Builder(@Nullable CommandManager<C> commandManager, @NonNull CommandMeta commandMeta, @Nullable Class<? extends C> senderType, @NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull Collection<CommandFlag<?>> flags) {
            this.commandManager = commandManager;
            this.senderType = senderType;
            this.commandArguments = Objects.requireNonNull(commandArguments, "Arguments may not be null");
            this.commandExecutionHandler = Objects.requireNonNull(commandExecutionHandler, "Execution handler may not be null");
            this.commandPermission = Objects.requireNonNull(commandPermission, "Permission may not be null");
            this.commandMeta = Objects.requireNonNull(commandMeta, "Meta may not be null");
            this.flags = Objects.requireNonNull(flags, "Flags may not be null");
        }

        public @NonNull Builder<C> meta(@NonNull String key, @NonNull String value) {
            SimpleCommandMeta commandMeta = SimpleCommandMeta.builder().with(this.commandMeta).with(key, value).build();
            return new Builder<C>(this.commandManager, commandMeta, this.senderType, this.commandArguments, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> manager(@Nullable CommandManager<C> commandManager) {
            return new Builder<C>(commandManager, this.commandMeta, this.senderType, this.commandArguments, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> literal(@NonNull String main, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases));
        }

        public @NonNull Builder<C> literal(@NonNull String main, @NonNull Description description, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases), description);
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder) {
            return this.argument(builder.build(), Description.empty());
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument) {
            return this.argument(argument, Description.empty());
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument, @NonNull Description description) {
            if (argument.isArgumentRegistered()) {
                throw new IllegalArgumentException("The provided argument has already been associated with a command. Use CommandArgument#copy to create a copy of the argument.");
            }
            argument.setArgumentRegistered();
            LinkedHashMap commandArgumentMap = new LinkedHashMap(this.commandArguments);
            commandArgumentMap.put(argument, description);
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandArgumentMap, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder, @NonNull Description description) {
            LinkedHashMap commandArgumentMap = new LinkedHashMap(this.commandArguments);
            commandArgumentMap.put(builder.build(), description);
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandArgumentMap, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <T> @NonNull Builder<C> argument(@NonNull Class<T> clazz, @NonNull String name, @NonNull Consumer<CommandArgument.Builder<C, T>> builderConsumer) {
            CommandArgument.Builder<C, T> builder = CommandArgument.ofType(clazz, name);
            if (this.commandManager != null) {
                builder.manager(this.commandManager);
            }
            builderConsumer.accept(builder);
            return this.argument(builder.build());
        }

        public <U, V> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> parserPair, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).simple(), description);
        }

        public <U, V, O> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Pair<String, String> names, @NonNull Pair<Class<U>, Class<V>> parserPair, @NonNull BiFunction<C, Pair<U, V>, O> mapper, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).withMapper(outputType, mapper), description);
        }

        public <U, V, W> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).simple(), description);
        }

        public <U, V, W, O> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull BiFunction<C, Triplet<U, V, W>, O> mapper, @NonNull Description description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).withMapper(outputType, mapper), description);
        }

        public @NonNull Builder<C> handler(@NonNull CommandExecutionHandler<C> commandExecutionHandler) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandArguments, commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> senderType(@NonNull Class<? extends C> senderType) {
            return new Builder<C>(this.commandManager, this.commandMeta, senderType, this.commandArguments, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull CommandPermission permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandArguments, this.commandExecutionHandler, permission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull String permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandArguments, this.commandExecutionHandler, Permission.of(permission), this.flags);
        }

        public @NonNull Builder<C> proxies(@NonNull Command<C> command) {
            Builder<C> builder = this;
            for (CommandArgument<C, ?> argument : command.getArguments()) {
                if (argument instanceof StaticArgument) continue;
                CommandArgument<C, ?> builtArgument = argument.copy();
                builder = builder.argument(builtArgument, Description.of(command.getArgumentDescription(argument)));
            }
            if (this.commandPermission.toString().isEmpty()) {
                builder = builder.permission(command.getCommandPermission());
            }
            return builder.handler(((Command)command).commandExecutionHandler);
        }

        public @NonNull Builder<C> hidden() {
            return this.meta("hidden", "true");
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag<T> flag) {
            ArrayList flags = new ArrayList(this.flags);
            flags.add(flag);
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandArguments, this.commandExecutionHandler, this.commandPermission, Collections.unmodifiableList(flags));
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag.Builder<T> builder) {
            return this.flag(builder.build());
        }

        public @NonNull Command<C> build() {
            LinkedHashMap commandArguments = new LinkedHashMap(this.commandArguments);
            if (!this.flags.isEmpty()) {
                FlagArgument flagArgument = new FlagArgument(this.flags);
                commandArguments.put(flagArgument, Description.of("Command flags"));
            }
            return new Command<C>(Collections.unmodifiableMap(commandArguments), this.commandExecutionHandler, this.senderType, this.commandPermission, this.commandMeta);
        }
    }
}

