/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.bukkit.BukkitCommandContextKeys;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.CloudBukkitCapabilities;
import cloud.commandframework.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import cloud.commandframework.execution.preprocessor.CommandPreprocessingContext;
import cloud.commandframework.execution.preprocessor.CommandPreprocessor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BukkitCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private final BukkitCommandManager<C> commandManager;
    private final @Nullable BukkitBackwardsBrigadierSenderMapper<C, ?> mapper;

    BukkitCommandPreprocessor(@NonNull BukkitCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.mapper = this.commandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER) ? new BukkitBackwardsBrigadierSenderMapper(this.commandManager) : null;
    }

    public void accept(@NonNull CommandPreprocessingContext<C> context) {
        if (this.mapper != null && !context.getCommandContext().contains("_cloud_brigadier_native_sender")) {
            context.getCommandContext().store("_cloud_brigadier_native_sender", this.mapper.apply(context.getCommandContext().getSender()));
        }
        context.getCommandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, (Object)this.commandManager.getBackwardsCommandSenderMapper().apply(context.getCommandContext().getSender()));
        context.getCommandContext().store(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES, this.commandManager.queryCapabilities());
    }
}

