/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.internal;

import cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import com.google.common.annotations.Beta;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public final class RegistryReflection {
    public static final @Nullable Field REGISTRY_REGISTRY;
    public static final @Nullable Method REGISTRY_GET;
    private static final Class<?> RESOURCE_LOCATION_CLASS;
    private static final Constructor<?> RESOURCE_LOCATION_CTR;

    private RegistryReflection() {
    }

    public static Object get(Object registry, String resourceLocation) {
        Objects.requireNonNull(REGISTRY_GET, "REGISTRY_GET");
        try {
            return REGISTRY_GET.invoke(registry, RegistryReflection.createResourceLocation(resourceLocation));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object registryByName(String name) {
        Objects.requireNonNull(REGISTRY_REGISTRY, "REGISTRY_REGISTRY");
        try {
            return RegistryReflection.get(REGISTRY_REGISTRY.get(null), name);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object createResourceLocation(String str) {
        try {
            return RESOURCE_LOCATION_CTR.newInstance(str);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        RESOURCE_LOCATION_CLASS = CraftBukkitReflection.needNMSClassOrElse("MinecraftKey", "net.minecraft.resources.MinecraftKey", "net.minecraft.resources.ResourceLocation");
        RESOURCE_LOCATION_CTR = CraftBukkitReflection.needConstructor(RESOURCE_LOCATION_CLASS, String.class);
        if (CraftBukkitReflection.MAJOR_REVISION < 17) {
            REGISTRY_REGISTRY = null;
            REGISTRY_GET = null;
        } else {
            Class registryClass;
            Class registryClassFinal = registryClass = CraftBukkitReflection.firstNonNullOrThrow(() -> "Registry", CraftBukkitReflection.findMCClass("core.IRegistry"), CraftBukkitReflection.findMCClass("core.Registry"));
            REGISTRY_REGISTRY = Arrays.stream(registryClass.getDeclaredFields()).filter(it -> it.getType().equals(registryClassFinal)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find Registry Registry field"));
            REGISTRY_REGISTRY.setAccessible(true);
            Class resourceLocationClass = CraftBukkitReflection.firstNonNullOrThrow(() -> "ResourceLocation class", CraftBukkitReflection.findMCClass("resources.ResourceLocation"), CraftBukkitReflection.findMCClass("resources.MinecraftKey"));
            REGISTRY_GET = Arrays.stream(registryClass.getDeclaredMethods()).filter(it -> it.getParameterCount() == 1 && it.getParameterTypes()[0].equals(resourceLocationClass) && it.getReturnType().equals(Object.class)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find Registry#get(ResourceLocation)"));
        }
    }
}

