/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.internal;

import cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import com.google.common.annotations.Beta;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

@Beta
public final class CommandBuildContextSupplier {
    private static final Class<?> COMMAND_BUILD_CONTEXT_CLASS = CraftBukkitReflection.needMCClass("commands.CommandBuildContext");
    private static final Constructor<?> COMMAND_BUILD_CONTEXT_CTR = COMMAND_BUILD_CONTEXT_CLASS.getDeclaredConstructors()[0];
    private static final Class<?> REG_ACC_CLASS = COMMAND_BUILD_CONTEXT_CTR.getParameterTypes()[0];
    private static final Class<?> MC_SERVER_CLASS = CraftBukkitReflection.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer");
    private static final Method GET_SERVER_METHOD;
    private static final Method REGISTRY_ACCESS;

    private CommandBuildContextSupplier() {
    }

    public static Object commandBuildContext() {
        try {
            Object server = GET_SERVER_METHOD.invoke(null, new Object[0]);
            return COMMAND_BUILD_CONTEXT_CTR.newInstance(REGISTRY_ACCESS.invoke(server, new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        REGISTRY_ACCESS = Arrays.stream(MC_SERVER_CLASS.getDeclaredMethods()).filter(m -> REG_ACC_CLASS.isAssignableFrom(m.getReturnType())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find MinecraftServer#registryAccess"));
        try {
            GET_SERVER_METHOD = MC_SERVER_CLASS.getDeclaredMethod("getServer", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

