/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.brigadier.argument.WrappedBrigadierParser;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.data.BlockPredicate;
import cloud.commandframework.bukkit.internal.CraftBukkitReflection;
import cloud.commandframework.bukkit.internal.MinecraftArgumentTypes;
import cloud.commandframework.context.CommandContext;
import com.mojang.brigadier.arguments.ArgumentType;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockPredicateArgument<C>
extends CommandArgument<C, BlockPredicate> {
    private BlockPredicateArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, BlockPredicate.class, suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull BlockPredicateArgument<C> of(@NonNull String name) {
        return BlockPredicateArgument.builder(name).build();
    }

    public static <C> @NonNull BlockPredicateArgument<C> optional(@NonNull String name) {
        return ((Builder)BlockPredicateArgument.builder(name).asOptional()).build();
    }

    private static <C> void registerParserSupplier(@NonNull BukkitCommandManager<C> commandManager) {
        commandManager.getParserRegistry().registerParserSupplier(TypeToken.get(BlockPredicate.class), params -> new Parser());
    }

    public static final class Parser<C>
    implements ArgumentParser<C, BlockPredicate> {
        private static final Class<?> TAG_CONTAINER_CLASS = CraftBukkitReflection.MAJOR_REVISION > 12 && CraftBukkitReflection.MAJOR_REVISION < 16 ? CraftBukkitReflection.needNMSClass("TagRegistry") : CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find TagContainer class", CraftBukkitReflection.findNMSClass("ITagRegistry"), CraftBukkitReflection.findMCClass("tags.ITagRegistry"), CraftBukkitReflection.findMCClass("tags.TagContainer"));
        private static final Class<?> CRAFT_WORLD_CLASS = CraftBukkitReflection.needOBCClass("CraftWorld");
        private static final Class<?> MINECRAFT_SERVER_CLASS = CraftBukkitReflection.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer");
        private static final Class<?> COMMAND_LISTENER_WRAPPER_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find CommandSourceStack class", CraftBukkitReflection.findNMSClass("CommandListenerWrapper"), CraftBukkitReflection.findMCClass("commands.CommandListenerWrapper"), CraftBukkitReflection.findMCClass("commands.CommandSourceStack"));
        private static final Class<?> ARGUMENT_BLOCK_PREDICATE_CLASS = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"block_predicate"));
        private static final Class<?> ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockPredicateArgument$Result class", CraftBukkitReflection.findNMSClass("ArgumentBlockPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.blocks.ArgumentBlockPredicate$b"), CraftBukkitReflection.findMCClass("commands.arguments.blocks.BlockPredicateArgument$Result"));
        private static final Class<?> SHAPE_DETECTOR_BLOCK_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockInWorld class", CraftBukkitReflection.findNMSClass("ShapeDetectorBlock"), CraftBukkitReflection.findMCClass("world.level.block.state.pattern.ShapeDetectorBlock"), CraftBukkitReflection.findMCClass("world.level.block.state.pattern.BlockInWorld"));
        private static final Class<?> LEVEL_READER_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find LevelReader class", CraftBukkitReflection.findNMSClass("IWorldReader"), CraftBukkitReflection.findMCClass("world.level.IWorldReader"), CraftBukkitReflection.findMCClass("world.level.LevelReader"));
        private static final Class<?> BLOCK_POSITION_CLASS = CraftBukkitReflection.firstNonNullOrThrow(() -> "Couldn't find BlockPos class", CraftBukkitReflection.findNMSClass("BlockPosition"), CraftBukkitReflection.findMCClass("core.BlockPosition"), CraftBukkitReflection.findMCClass("core.BlockPos"));
        private static final Constructor<?> BLOCK_POSITION_CTR = CraftBukkitReflection.needConstructor(BLOCK_POSITION_CLASS, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        private static final Constructor<?> SHAPE_DETECTOR_BLOCK_CTR = CraftBukkitReflection.needConstructor(SHAPE_DETECTOR_BLOCK_CLASS, LEVEL_READER_CLASS, BLOCK_POSITION_CLASS, Boolean.TYPE);
        private static final Method GET_HANDLE_METHOD = CraftBukkitReflection.needMethod(CRAFT_WORLD_CLASS, "getHandle", new Class[0]);
        private static final Method CREATE_PREDICATE_METHOD = CraftBukkitReflection.firstNonNullOrThrow(() -> "create on BlockPredicateArgument$Result", CraftBukkitReflection.findMethod(ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS, "create", TAG_CONTAINER_CLASS), CraftBukkitReflection.findMethod(ARGUMENT_BLOCK_PREDICATE_RESULT_CLASS, "a", TAG_CONTAINER_CLASS));
        private static final Method GET_SERVER_METHOD = CraftBukkitReflection.streamMethods(COMMAND_LISTENER_WRAPPER_CLASS).filter(it -> it.getReturnType().equals(MINECRAFT_SERVER_CLASS) && it.getParameterCount() == 0).findFirst().orElseThrow(() -> new IllegalStateException("Could not find CommandSourceStack#getServer."));
        private static final Method GET_TAG_REGISTRY_METHOD = CraftBukkitReflection.firstNonNullOrThrow(() -> "getTags method on MinecraftServer", CraftBukkitReflection.findMethod(MINECRAFT_SERVER_CLASS, "getTagRegistry", new Class[0]), CraftBukkitReflection.findMethod(MINECRAFT_SERVER_CLASS, "getTags", new Class[0]), CraftBukkitReflection.streamMethods(MINECRAFT_SERVER_CLASS).filter(it -> it.getReturnType().equals(TAG_CONTAINER_CLASS) && it.getParameterCount() == 0).findFirst().orElse(null));
        private final ArgumentParser<C, BlockPredicate> parser;

        public Parser() {
            try {
                this.parser = this.createParser();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to initialize BlockPredicate parser.", ex);
            }
        }

        private ArgumentParser<C, BlockPredicate> createParser() throws ReflectiveOperationException {
            return new WrappedBrigadierParser((ArgumentType)ARGUMENT_BLOCK_PREDICATE_CLASS.getConstructor(new Class[0]).newInstance(new Object[0])).map((ctx, result) -> {
                Object commandSourceStack = ctx.get("_cloud_brigadier_native_sender");
                try {
                    Object server = GET_SERVER_METHOD.invoke(commandSourceStack, new Object[0]);
                    Object tagRegistry = GET_TAG_REGISTRY_METHOD.invoke(server, new Object[0]);
                    Predicate predicate = (Predicate)CREATE_PREDICATE_METHOD.invoke(result, tagRegistry);
                    return ArgumentParseResult.success((Object)new BlockPredicateImpl(predicate));
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }

        public @NonNull ArgumentParseResult<@NonNull BlockPredicate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            return this.parser.parse(commandContext, inputQueue);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return this.parser.suggestions(commandContext, input);
        }

        private static final class BlockPredicateImpl
        implements BlockPredicate {
            private final Predicate<Object> predicate;

            BlockPredicateImpl(@NonNull Predicate<Object> predicate) {
                this.predicate = predicate;
            }

            private boolean testImpl(@NonNull Block block, boolean loadChunks) {
                try {
                    Object blockInWorld = SHAPE_DETECTOR_BLOCK_CTR.newInstance(GET_HANDLE_METHOD.invoke((Object)block.getWorld(), new Object[0]), BLOCK_POSITION_CTR.newInstance(block.getX(), block.getY(), block.getZ()), loadChunks);
                    return this.predicate.test(blockInWorld);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public boolean test(@NonNull Block block) {
                return this.testImpl(block, false);
            }

            @Override
            public @NonNull BlockPredicate loadChunks() {
                return new BlockPredicate(){

                    @Override
                    public @NonNull BlockPredicate loadChunks() {
                        return this;
                    }

                    @Override
                    public boolean test(Block block) {
                        return this.testImpl(block, true);
                    }
                };
            }
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, BlockPredicate, Builder<C>> {
        private Builder(@NonNull String name) {
            super(BlockPredicate.class, name);
        }

        public @NonNull BlockPredicateArgument<C> build() {
            return new BlockPredicateArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

