/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.brigadier.BrigadierManagerHolder;
import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.bukkit.BukkitCaptionRegistryFactory;
import cloud.commandframework.bukkit.BukkitCommandMeta;
import cloud.commandframework.bukkit.BukkitCommandMetaBuilder;
import cloud.commandframework.bukkit.BukkitCommandPreprocessor;
import cloud.commandframework.bukkit.BukkitPluginRegistrationHandler;
import cloud.commandframework.bukkit.BukkitSynchronizer;
import cloud.commandframework.bukkit.CloudBukkitCapabilities;
import cloud.commandframework.bukkit.CloudBukkitListener;
import cloud.commandframework.bukkit.CloudCommodoreManager;
import cloud.commandframework.bukkit.arguments.selector.MultipleEntitySelector;
import cloud.commandframework.bukkit.arguments.selector.MultiplePlayerSelector;
import cloud.commandframework.bukkit.arguments.selector.SingleEntitySelector;
import cloud.commandframework.bukkit.arguments.selector.SinglePlayerSelector;
import cloud.commandframework.bukkit.data.ProtoItemStack;
import cloud.commandframework.bukkit.parsers.BlockPredicateArgument;
import cloud.commandframework.bukkit.parsers.EnchantmentArgument;
import cloud.commandframework.bukkit.parsers.ItemStackArgument;
import cloud.commandframework.bukkit.parsers.ItemStackPredicateArgument;
import cloud.commandframework.bukkit.parsers.MaterialArgument;
import cloud.commandframework.bukkit.parsers.OfflinePlayerArgument;
import cloud.commandframework.bukkit.parsers.PlayerArgument;
import cloud.commandframework.bukkit.parsers.WorldArgument;
import cloud.commandframework.bukkit.parsers.location.Location2D;
import cloud.commandframework.bukkit.parsers.location.Location2DArgument;
import cloud.commandframework.bukkit.parsers.location.LocationArgument;
import cloud.commandframework.bukkit.parsers.selector.MultipleEntitySelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.MultiplePlayerSelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.SingleEntitySelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import cloud.commandframework.captions.CaptionRegistry;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.tasks.TaskFactory;
import cloud.commandframework.tasks.TaskRecipe;
import cloud.commandframework.tasks.TaskSynchronizer;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C> {
    private final Plugin owningPlugin;
    private final Function<CommandSender, C> commandSenderMapper;
    private final Function<C, CommandSender> backwardsCommandSenderMapper;
    private final TaskFactory taskFactory;
    private boolean splitAliases = false;

    public BukkitCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<@NonNull C>, @NonNull CommandExecutionCoordinator<@NonNull C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSender, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSender> backwardsCommandSenderMapper) throws Exception {
        super(commandExecutionCoordinator, new BukkitPluginRegistrationHandler());
        ((BukkitPluginRegistrationHandler)this.getCommandRegistrationHandler()).initialize(this);
        this.owningPlugin = owningPlugin;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        BukkitSynchronizer bukkitSynchronizer = new BukkitSynchronizer(owningPlugin);
        this.taskFactory = new TaskFactory((TaskSynchronizer)bukkitSynchronizer);
        this.registerCommandPreProcessor(new BukkitCommandPreprocessor(this));
        this.getParserRegistry().registerParserSupplier(TypeToken.get(World.class), parserParameters -> new WorldArgument.WorldParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Material.class), parserParameters -> new MaterialArgument.MaterialParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Player.class), parserParameters -> new PlayerArgument.PlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(OfflinePlayer.class), parserParameters -> new OfflinePlayerArgument.OfflinePlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Enchantment.class), parserParameters -> new EnchantmentArgument.EnchantmentParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Location.class), parserParameters -> new LocationArgument.LocationParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Location2D.class), parserParameters -> new Location2DArgument.Location2DParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(ProtoItemStack.class), parserParameters -> new ItemStackArgument.Parser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(SingleEntitySelector.class), parserParameters -> new SingleEntitySelectorArgument.SingleEntitySelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(SinglePlayerSelector.class), parserParameters -> new SinglePlayerSelectorArgument.SinglePlayerSelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorArgument.MultipleEntitySelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorArgument.MultiplePlayerSelectorParser());
        if (this.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.registerParserSupplierFor(ItemStackPredicateArgument.class);
            this.registerParserSupplierFor(BlockPredicateArgument.class);
        }
        this.owningPlugin.getServer().getPluginManager().registerEvents(new CloudBukkitListener(this), this.owningPlugin);
        this.setCaptionRegistry((CaptionRegistry)new BukkitCaptionRegistryFactory().create());
    }

    public static @NonNull BukkitCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<@NonNull CommandSender>, @NonNull CommandExecutionCoordinator<@NonNull CommandSender>> commandExecutionCoordinator) throws Exception {
        return new BukkitCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, UnaryOperator.identity(), UnaryOperator.identity());
    }

    public @NonNull TaskRecipe taskRecipe() {
        return this.taskFactory.recipe();
    }

    public @NonNull Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    public @NonNull BukkitCommandMeta createDefaultCommandMeta() {
        return BukkitCommandMetaBuilder.builder().withDescription("").build();
    }

    public final @NonNull Function<@NonNull CommandSender, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    protected final boolean getSplitAliases() {
        return this.splitAliases;
    }

    protected final void setSplitAliases(boolean value) {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.splitAliases = value;
    }

    protected final void checkBrigadierCompatibility() throws BrigadierFailureException {
        if (!this.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            throw new BrigadierFailureException(BrigadierFailureReason.VERSION_TOO_LOW, (Throwable)new IllegalArgumentException("Brigadier does not appear to be present on the currently running server. This is usually due to running too old a version of Minecraft (Brigadier is implemented in 1.13 and newer)."));
        }
    }

    public final boolean queryCapability(@NonNull CloudBukkitCapabilities capability) {
        return capability.capable();
    }

    public final @NonNull Set<@NonNull CloudBukkitCapabilities> queryCapabilities() {
        return CloudBukkitCapabilities.CAPABLE;
    }

    public void registerBrigadier() throws BrigadierFailureException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        try {
            CloudCommodoreManager cloudCommodoreManager = new CloudCommodoreManager(this);
            cloudCommodoreManager.initialize(this);
            this.setCommandRegistrationHandler(cloudCommodoreManager);
            this.setSplitAliases(true);
        }
        catch (Throwable e) {
            throw new BrigadierFailureException(BrigadierFailureReason.COMMODORE_NOT_PRESENT, e);
        }
    }

    public @Nullable CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.getCommandRegistrationHandler() instanceof CloudCommodoreManager) {
            return ((CloudCommodoreManager)this.getCommandRegistrationHandler()).brigadierManager();
        }
        return null;
    }

    public final @NonNull String stripNamespace(@NonNull String command) {
        String namespace;
        @NonNull String input = command.charAt(0) == '/' ? command.substring(1) : command;
        if (input.startsWith(namespace = String.format("%s:", this.getOwningPlugin().getName().toLowerCase()))) {
            input = input.substring(namespace.length());
        }
        return input;
    }

    public final @NonNull Function<@NonNull C, @NonNull CommandSender> getBackwardsCommandSenderMapper() {
        return this.backwardsCommandSenderMapper;
    }

    private void registerParserSupplierFor(@NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", BukkitCommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, new Object[]{this});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    final void lockIfBrigadierCapable() {
        if (this.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            this.lockRegistration();
        }
    }

    public static final class BrigadierFailureException
    extends IllegalStateException {
        private static final long serialVersionUID = 7816660840063155703L;
        private final BrigadierFailureReason reason;

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason) {
            this.reason = reason;
        }

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason, @NonNull Throwable cause) {
            super(cause);
            this.reason = reason;
        }

        public @NonNull BrigadierFailureReason getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return String.format("Could not initialize Brigadier mappings. Reason: %s (%s)", this.reason.name().toLowerCase().replace("_", " "), this.getCause() == null ? "" : this.getCause().getMessage());
        }
    }

    public static enum BrigadierFailureReason {
        COMMODORE_NOT_PRESENT,
        VERSION_TOO_LOW,
        PAPER_BRIGADIER_INITIALIZATION_FAILURE;

    }
}

