/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers.location;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.bukkit.BukkitCaptionKeys;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinate;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinateParser;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinateType;
import cloud.commandframework.captions.Caption;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.ParserException;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LocationArgument<C>
extends CommandArgument<C, Location> {
    private LocationArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new LocationParser(), defaultValue, TypeToken.get(Location.class), suggestionsProvider, argumentPreprocessors);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Location> of(@NonNull String name) {
        return LocationArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Location> optional(@NonNull String name) {
        return LocationArgument.newBuilder(name).asOptional().build();
    }

    private static class LocationParseException
    extends ParserException {
        private static final long serialVersionUID = -3261835227265878218L;

        protected LocationParseException(@NonNull CommandContext<?> context, @NonNull FailureReason reason, @NonNull String input) {
            super(LocationParser.class, context, reason.getCaption(), new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }

        public static enum FailureReason {
            WRONG_FORMAT(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_INVALID_FORMAT),
            MIXED_LOCAL_ABSOLUTE(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_LOCATION_MIXED_LOCAL_ABSOLUTE);

            private final Caption caption;

            private FailureReason(Caption caption) {
                this.caption = caption;
            }

            public @NonNull Caption getCaption() {
                return this.caption;
            }
        }
    }

    public static final class LocationParser<C>
    implements ArgumentParser<C, Location> {
        private static final int EXPECTED_PARAMETER_COUNT = 3;
        private final LocationCoordinateParser<C> locationCoordinateParser = new LocationCoordinateParser();

        public @NonNull ArgumentParseResult<@NonNull Location> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            if (inputQueue.size() < 3) {
                StringBuilder input = new StringBuilder();
                for (int i = 0; i < inputQueue.size(); ++i) {
                    input.append((String)((LinkedList)inputQueue).get(i));
                    if (i + 1 >= inputQueue.size()) continue;
                    input.append(" ");
                }
                return ArgumentParseResult.failure((Throwable)((Object)new LocationParseException(commandContext, LocationParseException.FailureReason.WRONG_FORMAT, input.toString())));
            }
            LocationCoordinate[] coordinates = new LocationCoordinate[3];
            for (int i = 0; i < 3; ++i) {
                ArgumentParseResult<@NonNull LocationCoordinate> coordinate = this.locationCoordinateParser.parse(commandContext, inputQueue);
                if (coordinate.getFailure().isPresent()) {
                    return ArgumentParseResult.failure((Throwable)((Throwable)coordinate.getFailure().get()));
                }
                coordinates[i] = (LocationCoordinate)coordinate.getParsedValue().orElseThrow(NullPointerException::new);
            }
            CommandSender bukkitSender = (CommandSender)commandContext.get("BukkitCommandSender");
            Location originalLocation = bukkitSender instanceof BlockCommandSender ? ((BlockCommandSender)bukkitSender).getBlock().getLocation() : (bukkitSender instanceof Entity ? ((Entity)bukkitSender).getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
            if (coordinates[0].getType() == LocationCoordinateType.LOCAL != (coordinates[1].getType() == LocationCoordinateType.LOCAL) || coordinates[0].getType() == LocationCoordinateType.LOCAL != (coordinates[2].getType() == LocationCoordinateType.LOCAL)) {
                return ArgumentParseResult.failure((Throwable)((Object)new LocationParseException(commandContext, LocationParseException.FailureReason.MIXED_LOCAL_ABSOLUTE, "")));
            }
            if (coordinates[0].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setX(coordinates[0].getCoordinate());
            } else if (coordinates[0].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(coordinates[0].getCoordinate(), 0.0, 0.0);
            }
            if (coordinates[1].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setY(coordinates[1].getCoordinate());
            } else if (coordinates[1].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(0.0, coordinates[1].getCoordinate(), 0.0);
            }
            if (coordinates[2].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setZ(coordinates[2].getCoordinate());
            } else if (coordinates[2].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(0.0, 0.0, coordinates[2].getCoordinate());
            } else {
                double multiplier = 0.017453292;
                double f = Math.cos((double)(originalLocation.getYaw() + 90.0f) * 0.017453292);
                double f1 = Math.sin((originalLocation.getY() + 90.0) * 0.017453292);
                double f2 = Math.cos((double)(-originalLocation.getPitch()) * 0.017453292);
                double f3 = Math.sin((double)(-originalLocation.getPitch()) * 0.017453292);
                double f4 = Math.cos((double)(-originalLocation.getPitch() + 90.0f) * 0.017453292);
                double f5 = Math.sin((double)(-originalLocation.getPitch() + 90.0f) * 0.017453292);
                Vector vec1 = new Vector(f * f2, f3, f1 * f2);
                Vector vec2 = new Vector(f * f4, f5, f1 * f4);
                Vector vec3 = vec1.crossProduct(vec2).multiply(-1);
                Vector vec4 = new Vector(vec1.getX() * coordinates[2].getCoordinate() + vec2.getX() * coordinates[1].getCoordinate() + vec3.getX() * coordinates[0].getCoordinate(), vec1.getY() * coordinates[2].getCoordinate() + vec2.getY() * coordinates[1].getCoordinate() + vec3.getY() * coordinates[0].getCoordinate(), vec1.getZ() * coordinates[1].getCoordinate() + vec2.getZ() * coordinates[1].getCoordinate() + vec3.getZ() * coordinates[0].getCoordinate());
                originalLocation.add(vec4);
            }
            return ArgumentParseResult.success((Object)originalLocation);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            String workingInput;
            String prefix;
            if (input.startsWith("~") || input.startsWith("^")) {
                prefix = Character.toString(input.charAt(0));
                workingInput = input.substring(1);
            } else {
                prefix = "";
                workingInput = input;
            }
            return IntegerArgument.IntegerParser.getSuggestions((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE, (String)workingInput).stream().map(string -> prefix + string).collect(Collectors.toList());
        }

        public int getRequestedArgumentCount() {
            return 3;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Location> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(Location.class), name);
        }

        public @NonNull CommandArgument<@NonNull C, @NonNull Location> build() {
            return new LocationArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), new LinkedList());
        }
    }
}

