/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.BukkitCaptionKeys;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnchantmentArgument<C>
extends CommandArgument<C, Enchantment> {
    protected EnchantmentArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new EnchantmentParser(), defaultValue, Enchantment.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Enchantment> of(@NonNull String name) {
        return EnchantmentArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Enchantment> optional(@NonNull String name) {
        return EnchantmentArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Enchantment> optional(@NonNull String name, @NonNull Enchantment enchantment) {
        return EnchantmentArgument.newBuilder(name).asOptionalWithDefault(enchantment.getKey().toString()).build();
    }

    public static final class EnchantmentParseException
    extends ParserException {
        private static final long serialVersionUID = 1415174766296065151L;
        private final String input;

        public EnchantmentParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(EnchantmentParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_ENCHANTMENT, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }

    public static final class EnchantmentParser<C>
    implements ArgumentParser<C, Enchantment> {
        public @NonNull ArgumentParseResult<Enchantment> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            NamespacedKey key;
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(EnchantmentParser.class, commandContext));
            }
            if (input.contains(":")) {
                String[] splitInput = input.split(":");
                key = new NamespacedKey(splitInput[0], splitInput[1]);
            } else {
                key = NamespacedKey.minecraft((String)input);
            }
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)key);
            if (enchantment == null) {
                return ArgumentParseResult.failure((Throwable)((Object)new EnchantmentParseException(input, commandContext)));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)enchantment);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> completions = new ArrayList<String>();
            for (Enchantment value : Enchantment.values()) {
                if (value.getKey().getNamespace().equals("minecraft")) {
                    completions.add(value.getKey().getKey());
                    continue;
                }
                completions.add(value.getKey().toString());
            }
            return completions;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Enchantment> {
        private Builder(@NonNull String name) {
            super(Enchantment.class, name);
        }

        public @NonNull CommandArgument<C, Enchantment> build() {
            return new EnchantmentArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

