/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.BukkitPluginRegistrationHandler;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CommandSuggestionsListener<C>
implements Listener {
    private final BukkitCommandManager<C> bukkitCommandManager;

    CommandSuggestionsListener(@NonNull BukkitCommandManager<C> bukkitCommandManager) {
        this.bukkitCommandManager = bukkitCommandManager;
    }

    @EventHandler
    void onTabCompletion(@NonNull TabCompleteEvent event) {
        String commandLabel;
        if (event.getBuffer().isEmpty() || !event.getBuffer().startsWith("/")) {
            return;
        }
        BukkitPluginRegistrationHandler bukkitPluginRegistrationHandler = (BukkitPluginRegistrationHandler)this.bukkitCommandManager.getCommandRegistrationHandler();
        if (!bukkitPluginRegistrationHandler.isRecognized(commandLabel = event.getBuffer().substring(1).split(" ")[0])) {
            return;
        }
        CommandSender sender = event.getSender();
        C cloudSender = this.bukkitCommandManager.getCommandSenderMapper().apply(sender);
        String inputBuffer = this.bukkitCommandManager.stripNamespace(event.getBuffer());
        ArrayList suggestions = new ArrayList(this.bukkitCommandManager.suggest(cloudSender, inputBuffer));
        event.setCompletions(suggestions);
    }
}

