/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.tasks.TaskConsumer;
import cloud.commandframework.tasks.TaskFunction;
import cloud.commandframework.tasks.TaskSynchronizer;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BukkitSynchronizer
implements TaskSynchronizer {
    private final Plugin plugin;

    BukkitSynchronizer(@NonNull Plugin plugin) {
        this.plugin = plugin;
    }

    public <I> CompletableFuture<Void> runSynchronous(@NonNull I input, @NonNull TaskConsumer<I> consumer) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
            consumer.accept(input);
            future.complete(null);
        });
        return future;
    }

    public <I, O> CompletableFuture<O> runSynchronous(@NonNull I input, @NonNull TaskFunction<I, O> function) {
        CompletableFuture future = new CompletableFuture();
        this.plugin.getServer().getScheduler().runTask(this.plugin, () -> future.complete(function.apply(input)));
        return future;
    }

    public <I> CompletableFuture<Void> runAsynchronous(@NonNull I input, @NonNull TaskConsumer<I> consumer) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> {
            consumer.accept(input);
            future.complete(null);
        });
        return future;
    }

    public <I, O> CompletableFuture<O> runAsynchronous(@NonNull I input, @NonNull TaskFunction<I, O> function) {
        CompletableFuture future = new CompletableFuture();
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> future.complete(function.apply(input)));
        return future;
    }
}

