/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.brigadier;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.arguments.compound.CompoundArgument;
import cloud.commandframework.arguments.compound.FlagArgument;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.standard.BooleanArgument;
import cloud.commandframework.arguments.standard.ByteArgument;
import cloud.commandframework.arguments.standard.DoubleArgument;
import cloud.commandframework.arguments.standard.FloatArgument;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.arguments.standard.ShortArgument;
import cloud.commandframework.arguments.standard.StringArgument;
import cloud.commandframework.arguments.standard.StringArrayArgument;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.Permission;
import cloud.commandframework.types.tuples.Pair;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CloudBrigadierManager<C, S> {
    private final Map<Class<?>, Pair<Function<? extends ArgumentParser<C, ?>, ? extends ArgumentType<?>>, Boolean>> mappers = new HashMap();
    private final Map<@NonNull Class<?>, @NonNull Supplier<@Nullable ArgumentType<?>>> defaultArgumentTypeSuppliers = new HashMap();
    private final Supplier<cloud.commandframework.context.CommandContext<C>> dummyContextProvider;
    private final CommandManager<C> commandManager;
    private Function<S, C> brigadierCommandSenderMapper;

    public CloudBrigadierManager(@NonNull CommandManager<C> commandManager, @NonNull Supplier<@NonNull cloud.commandframework.context.CommandContext<C>> dummyContextProvider) {
        this.commandManager = commandManager;
        this.dummyContextProvider = dummyContextProvider;
        this.registerInternalMappings();
    }

    private void registerInternalMappings() {
        this.registerMapping(new TypeToken<ByteArgument.ByteParser<C>>(){}, true, argument -> {
            boolean hasMax;
            boolean hasMin = argument.getMin() != -128;
            boolean bl = hasMax = argument.getMax() != 127;
            if (hasMin) {
                return IntegerArgumentType.integer((int)argument.getMin(), (int)argument.getMax());
            }
            if (hasMax) {
                return IntegerArgumentType.integer((int)-128, (int)argument.getMax());
            }
            return IntegerArgumentType.integer();
        });
        this.registerMapping(new TypeToken<ShortArgument.ShortParser<C>>(){}, true, argument -> {
            boolean hasMax;
            boolean hasMin = argument.getMin() != Short.MIN_VALUE;
            boolean bl = hasMax = argument.getMax() != Short.MAX_VALUE;
            if (hasMin) {
                return IntegerArgumentType.integer((int)argument.getMin(), (int)argument.getMax());
            }
            if (hasMax) {
                return IntegerArgumentType.integer((int)Short.MIN_VALUE, (int)argument.getMax());
            }
            return IntegerArgumentType.integer();
        });
        this.registerMapping(new TypeToken<IntegerArgument.IntegerParser<C>>(){}, true, argument -> {
            boolean hasMax;
            boolean hasMin = argument.getMin() != Integer.MIN_VALUE;
            boolean bl = hasMax = argument.getMax() != Integer.MAX_VALUE;
            if (hasMin) {
                return IntegerArgumentType.integer((int)argument.getMin(), (int)argument.getMax());
            }
            if (hasMax) {
                return IntegerArgumentType.integer((int)Integer.MIN_VALUE, (int)argument.getMax());
            }
            return IntegerArgumentType.integer();
        });
        this.registerMapping(new TypeToken<FloatArgument.FloatParser<C>>(){}, true, argument -> {
            boolean hasMax;
            boolean hasMin = argument.getMin() != Float.NEGATIVE_INFINITY;
            boolean bl = hasMax = argument.getMax() != Float.POSITIVE_INFINITY;
            if (hasMin) {
                return FloatArgumentType.floatArg((float)argument.getMin(), (float)argument.getMax());
            }
            if (hasMax) {
                return FloatArgumentType.floatArg((float)Float.NEGATIVE_INFINITY, (float)argument.getMax());
            }
            return FloatArgumentType.floatArg();
        });
        this.registerMapping(new TypeToken<DoubleArgument.DoubleParser<C>>(){}, true, argument -> {
            boolean hasMax;
            boolean hasMin = argument.getMin() != Double.NEGATIVE_INFINITY;
            boolean bl = hasMax = argument.getMax() != Double.POSITIVE_INFINITY;
            if (hasMin) {
                return DoubleArgumentType.doubleArg((double)argument.getMin(), (double)argument.getMax());
            }
            if (hasMax) {
                return DoubleArgumentType.doubleArg((double)Double.NEGATIVE_INFINITY, (double)argument.getMax());
            }
            return DoubleArgumentType.doubleArg();
        });
        this.registerMapping(new TypeToken<BooleanArgument.BooleanParser<C>>(){}, true, argument -> BoolArgumentType.bool());
        this.registerMapping(new TypeToken<StringArgument.StringParser<C>>(){}, false, argument -> {
            switch (argument.getStringMode()) {
                case QUOTED: {
                    return StringArgumentType.string();
                }
                case GREEDY: {
                    return StringArgumentType.greedyString();
                }
            }
            return StringArgumentType.word();
        });
        this.registerMapping(new TypeToken<FlagArgument.FlagArgumentParser<C>>(){}, false, argument -> StringArgumentType.greedyString());
        this.registerMapping(new TypeToken<StringArrayArgument.StringArrayParser<C>>(){}, false, argument -> StringArgumentType.greedyString());
    }

    public void brigadierSenderMapper(@NonNull Function<@NonNull S, @Nullable C> mapper) {
        this.brigadierCommandSenderMapper = mapper;
    }

    public @Nullable Function<@NonNull S, @Nullable C> brigadierSenderMapper() {
        return this.brigadierCommandSenderMapper;
    }

    public void setNativeNumberSuggestions(boolean nativeNumberSuggestions) {
        this.setNativeSuggestions(new TypeToken<ByteArgument.ByteParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<ShortArgument.ShortParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<IntegerArgument.IntegerParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<FloatArgument.FloatParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<DoubleArgument.DoubleParser<C>>(){}, nativeNumberSuggestions);
    }

    public <T, K extends ArgumentParser<C, T>> void setNativeSuggestions(@NonNull TypeToken<K> argumentType, boolean nativeSuggestions) throws IllegalArgumentException {
        Pair<Function<? extends ArgumentParser<C, ?>, ? extends ArgumentType<?>>, Boolean> pair = this.mappers.get(GenericTypeReflector.erase((Type)argumentType.getType()));
        if (pair == null) {
            throw new IllegalArgumentException("No mapper registered for type: " + GenericTypeReflector.erase((Type)argumentType.getType()).toGenericString());
        }
        this.mappers.put(GenericTypeReflector.erase((Type)argumentType.getType()), Pair.of((Object)((Function)pair.getFirst()), (Object)nativeSuggestions));
    }

    public <T, K extends ArgumentParser<C, T>, O> void registerMapping(@NonNull TypeToken<K> argumentType, boolean nativeSuggestions, @NonNull Function<@NonNull ? extends K, @NonNull ? extends ArgumentType<O>> mapper) {
        this.mappers.put(GenericTypeReflector.erase((Type)argumentType.getType()), Pair.of(mapper, (Object)nativeSuggestions));
    }

    public void registerDefaultArgumentTypeSupplier(@NonNull Class<?> clazz, @NonNull Supplier<@Nullable ArgumentType<?>> supplier) {
        this.defaultArgumentTypeSuppliers.put(clazz, supplier);
    }

    private <T, K extends ArgumentParser<?, ?>> @Nullable Pair<@NonNull ArgumentType<?>, @NonNull Boolean> getArgument(@NonNull TypeToken<?> valueType, @NonNull TypeToken<T> argumentType, @NonNull K argument) {
        K commandArgument = argument;
        Pair<Function<? extends ArgumentParser<C, ?>, ? extends ArgumentType<?>>, Boolean> pair = this.mappers.get(GenericTypeReflector.erase((Type)argumentType.getType()));
        if (pair == null || pair.getFirst() == null) {
            return this.createDefaultMapper(valueType);
        }
        return Pair.of((Object)((ArgumentType)((Function)pair.getFirst()).apply(commandArgument)), (Object)((Boolean)pair.getSecond()));
    }

    private <T, K extends ArgumentParser<C, T>> @NonNull Pair<@NonNull ArgumentType<?>, @NonNull Boolean> createDefaultMapper(@NonNull TypeToken<?> clazz) {
        Supplier<ArgumentType<?>> argumentTypeSupplier = this.defaultArgumentTypeSuppliers.get(GenericTypeReflector.erase((Type)clazz.getType()));
        @Nullable ArgumentType<?> defaultType = argumentTypeSupplier != null ? argumentTypeSupplier.get() : null;
        if (defaultType != null) {
            return Pair.of(argumentTypeSupplier.get(), (Object)true);
        }
        return Pair.of((Object)StringArgumentType.string(), (Object)false);
    }

    public @NonNull LiteralCommandNode<S> createLiteralCommandNode(@NonNull String label, @NonNull Command<C> cloudCommand, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker, boolean forceRegister, @NonNull com.mojang.brigadier.Command<S> executor) {
        CommandTree.Node node = this.commandManager.getCommandTree().getNamedNode(((CommandArgument)cloudCommand.getArguments().get(0)).getName());
        SuggestionProvider provider = (context, builder) -> this.buildSuggestions(context, null, (CommandArgument)node.getValue(), builder);
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)label).requires(sender -> permissionChecker.test(sender, (CommandPermission)node.getNodeMeta().getOrDefault("permission", Permission.empty())));
        if (forceRegister || node.getValue() != null && ((CommandArgument)node.getValue()).getOwningCommand() != null) {
            literalArgumentBuilder.executes(executor);
        }
        literalArgumentBuilder.executes(executor);
        LiteralCommandNode constructedRoot = literalArgumentBuilder.build();
        for (CommandTree.Node child : node.getChildren()) {
            constructedRoot.addChild(this.constructCommandNode(forceRegister, child, permissionChecker, executor, provider).build());
        }
        return constructedRoot;
    }

    public @NonNull LiteralCommandNode<S> createLiteralCommandNode(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTree.Node<@NonNull CommandArgument<C, ?>> cloudCommand, @NonNull LiteralCommandNode<S> root, @NonNull SuggestionProvider<S> suggestionProvider, @NonNull com.mojang.brigadier.Command<S> executor, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)root.getLiteral()).requires(sender -> permissionChecker.test(sender, (CommandPermission)cloudCommand.getNodeMeta().getOrDefault("permission", Permission.empty())));
        if (cloudCommand.getValue() != null && ((CommandArgument)cloudCommand.getValue()).getOwningCommand() != null) {
            literalArgumentBuilder.executes(executor);
        }
        LiteralCommandNode constructedRoot = literalArgumentBuilder.build();
        for (CommandTree.Node child : cloudCommand.getChildren()) {
            constructedRoot.addChild(this.constructCommandNode(false, child, permissionChecker, executor, suggestionProvider).build());
        }
        return constructedRoot;
    }

    private @NonNull ArgumentBuilder<S, ?> constructCommandNode(boolean forceExecutor, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CommandTree.Node<CommandArgument<C, ?>> root, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker, @NonNull com.mojang.brigadier.Command<S> executor, SuggestionProvider<S> suggestionProvider) {
        ArgumentBuilder argumentBuilder;
        if (root.getValue() instanceof CompoundArgument) {
            CompoundArgument compoundArgument = (CompoundArgument)root.getValue();
            Object[] parsers = compoundArgument.getParserTuple().toArray();
            Object[] types = compoundArgument.getTypes().toArray();
            Object[] names = compoundArgument.getNames().toArray();
            ArgumentBuilder[] argumentBuilders = new ArgumentBuilder[parsers.length];
            for (int i = parsers.length - 1; i >= 0; --i) {
                ArgumentBuilder fragmentBuilder;
                ArgumentParser parser = (ArgumentParser)parsers[i];
                Pair<ArgumentType<?>, Boolean> pair = this.getArgument(TypeToken.get((Class)((Class)types[i])), TypeToken.get(parser.getClass()), parser);
                SuggestionProvider<S> provider = (Boolean)pair.getSecond() != false ? null : suggestionProvider;
                argumentBuilders[i] = fragmentBuilder = RequiredArgumentBuilder.argument((String)((String)names[i]), (ArgumentType)((ArgumentType)pair.getFirst())).suggests(provider).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())));
                if (forceExecutor || i == parsers.length - 1 && (root.isLeaf() || !((CommandArgument)root.getValue()).isRequired())) {
                    fragmentBuilder.executes(executor);
                }
                if (i + 1 >= parsers.length) continue;
                fragmentBuilder.then(argumentBuilders[i + 1]);
            }
            for (CommandTree.Node node2 : root.getChildren()) {
                argumentBuilders[parsers.length - 1].then(this.constructCommandNode(forceExecutor, node2, permissionChecker, executor, suggestionProvider));
            }
            return argumentBuilders[0];
        }
        if (root.getValue() instanceof StaticArgument) {
            argumentBuilder = ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)((CommandArgument)root.getValue()).getName()).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())))).executes(executor);
        } else {
            Pair<ArgumentType<?>, Boolean> pair = this.getArgument(((CommandArgument)root.getValue()).getValueType(), TypeToken.get(((CommandArgument)root.getValue()).getParser().getClass()), ((CommandArgument)root.getValue()).getParser());
            SuggestionProvider provider = (Boolean)pair.getSecond() != false ? null : (context, builder) -> this.buildSuggestions(context, root.getParent(), (CommandArgument)root.getValue(), builder);
            argumentBuilder = RequiredArgumentBuilder.argument((String)((CommandArgument)root.getValue()).getName(), (ArgumentType)((ArgumentType)pair.getFirst())).suggests(provider).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())));
        }
        if (forceExecutor || root.isLeaf() || !((CommandArgument)root.getValue()).isRequired()) {
            argumentBuilder.executes(executor);
        }
        if (root.getChildren().stream().noneMatch(node -> ((CommandArgument)node.getValue()).isRequired())) {
            argumentBuilder.executes(executor);
        }
        for (CommandTree.Node node3 : root.getChildren()) {
            argumentBuilder.then(this.constructCommandNode(forceExecutor, node3, permissionChecker, executor, suggestionProvider));
        }
        return argumentBuilder;
    }

    private @NonNull CompletableFuture<Suggestions> buildSuggestions(@Nullable CommandContext<S> senderContext, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CommandTree.Node<CommandArgument<C, ?>> parentNode, @NonNull CommandArgument<C, ?> argument, @NonNull SuggestionsBuilder builder) {
        String leading;
        cloud.commandframework.context.CommandContext commandContext;
        if (this.brigadierCommandSenderMapper == null || senderContext == null) {
            commandContext = this.dummyContextProvider.get();
        } else {
            C cloudSender = this.brigadierCommandSenderMapper.apply(senderContext.getSource());
            commandContext = new cloud.commandframework.context.CommandContext(true, cloudSender, this.commandManager);
        }
        String command = builder.getInput();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if ((leading = command.split(" ")[0]).contains(":")) {
            command = command.substring(leading.split(":")[0].length() + 1);
        }
        List suggestionsUnfiltered = this.commandManager.suggest(commandContext.getSender(), command);
        ArrayList<String> suggestions = new ArrayList<String>(suggestionsUnfiltered);
        if (parentNode != null) {
            Set siblingLiterals = parentNode.getChildren().stream().map(CommandTree.Node::getValue).flatMap(arg -> arg instanceof StaticArgument ? ((StaticArgument)arg).getAliases().stream() : Stream.empty()).collect(Collectors.toSet());
            suggestions.removeIf(siblingLiterals::contains);
        }
        SuggestionsBuilder suggestionsBuilder = builder;
        int lastIndexOfSpaceInRemainingString = builder.getRemaining().lastIndexOf(32);
        if (lastIndexOfSpaceInRemainingString != -1) {
            suggestionsBuilder = builder.createOffset(builder.getStart() + lastIndexOfSpaceInRemainingString + 1);
        }
        for (String suggestion : suggestions) {
            String tooltip = argument.getName();
            if (!(argument instanceof StaticArgument)) {
                tooltip = argument.isRequired() ? '<' + tooltip + '>' : '[' + tooltip + ']';
            }
            suggestionsBuilder = suggestionsBuilder.suggest(suggestion, (Message)new LiteralMessage(tooltip));
        }
        return suggestionsBuilder.buildFuture();
    }
}

