/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.annotations.AnnotationAccessor;
import cloud.commandframework.annotations.AnnotationParser;
import cloud.commandframework.annotations.Argument;
import cloud.commandframework.annotations.Flag;
import cloud.commandframework.annotations.injection.ParameterInjectorRegistry;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.FlagContext;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.execution.CommandExecutionHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MethodCommandExecutionHandler<C>
implements CommandExecutionHandler<C> {
    private final CommandMethodContext<C> context;
    private final Parameter[] parameters;
    private final MethodHandle methodHandle;
    private final AnnotationAccessor annotationAccessor;
    private final AnnotationParser<C> annotationParser;

    public MethodCommandExecutionHandler(@NonNull CommandMethodContext<C> context) throws Exception {
        this.context = context;
        this.methodHandle = MethodHandles.lookup().unreflect(((CommandMethodContext)context).method).bindTo(((CommandMethodContext)context).instance);
        this.parameters = ((CommandMethodContext)context).method.getParameters();
        this.annotationAccessor = AnnotationAccessor.of((AnnotatedElement)((CommandMethodContext)context).method);
        this.annotationParser = context.annotationParser();
    }

    public void execute(@NonNull CommandContext<C> commandContext) {
        try {
            this.methodHandle.invokeWithArguments(this.createParameterValues(commandContext, commandContext.flags(), this.parameters));
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandExecutionException(throwable, commandContext);
        }
    }

    protected final List<Object> createParameterValues(CommandContext<C> commandContext, FlagContext flagContext, Parameter[] parameters) {
        ArrayList<Object> arguments = new ArrayList<Object>(parameters.length);
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Argument.class)) {
                Argument argument = parameter.getAnnotation(Argument.class);
                String argumentName = argument.value().equals("__INFERRED_ARGUMENT_NAME__") ? parameter.getName() : this.annotationParser.processString(argument.value());
                CommandArgument commandArgument = (CommandArgument)((CommandMethodContext)this.context).commandArguments.get(argumentName);
                if (commandArgument.isRequired()) {
                    arguments.add(commandContext.get(argumentName));
                    continue;
                }
                Object optional = commandContext.getOptional(argumentName).orElse(null);
                arguments.add(optional);
                continue;
            }
            if (parameter.isAnnotationPresent(Flag.class)) {
                Flag flag = parameter.getAnnotation(Flag.class);
                String flagName = this.annotationParser.processString(flag.value());
                if (parameter.getType().equals(Boolean.TYPE)) {
                    arguments.add(flagContext.isPresent(flagName));
                    continue;
                }
                if (flag.repeatable() && parameter.getType().isAssignableFrom(List.class)) {
                    arguments.add(flagContext.getAll(flagName));
                    continue;
                }
                arguments.add(flagContext.getValue(flagName, null));
                continue;
            }
            if (parameter.getType().isAssignableFrom(commandContext.getSender().getClass())) {
                arguments.add(commandContext.getSender());
                continue;
            }
            Optional value = ((CommandMethodContext)this.context).injectorRegistry.getInjectable(parameter.getType(), commandContext, AnnotationAccessor.of((AnnotationAccessor[])new AnnotationAccessor[]{AnnotationAccessor.of((AnnotatedElement)parameter), this.annotationAccessor}));
            if (value.isPresent()) {
                arguments.add(value.get());
                continue;
            }
            throw new IllegalArgumentException(String.format("Could not create value for parameter '%s' of type '%s' in method '%s'", parameter.getName(), parameter.getType().getTypeName(), this.methodHandle.toString()));
        }
        return arguments;
    }

    public @NonNull CommandMethodContext<C> context() {
        return this.context;
    }

    public final @NonNull Parameter @NonNull [] parameters() {
        return this.parameters;
    }

    public final @NonNull MethodHandle methodHandle() {
        return this.methodHandle;
    }

    public final AnnotationAccessor annotationAccessor() {
        return this.annotationAccessor;
    }

    public static class CommandMethodContext<C> {
        private final Object instance;
        private final Map<String, CommandArgument<C, ?>> commandArguments;
        private final Method method;
        private final ParameterInjectorRegistry<C> injectorRegistry;
        private final AnnotationParser<C> annotationParser;

        CommandMethodContext(@NonNull Object instance, @NonNull Map<@NonNull String, @NonNull CommandArgument<@NonNull C, @NonNull ?>> commandArguments, @NonNull Method method, @NonNull AnnotationParser<C> annotationParser) {
            this.instance = instance;
            this.commandArguments = commandArguments;
            this.method = method;
            this.method.setAccessible(true);
            this.injectorRegistry = annotationParser.getParameterInjectorRegistry();
            this.annotationParser = annotationParser;
        }

        public @NonNull Object instance() {
            return this.instance;
        }

        public final @NonNull Method method() {
            return this.method;
        }

        public final @NonNull Map<@NonNull String, @NonNull CommandArgument<C, ?>> commandArguments() {
            return this.commandArguments;
        }

        public final @NonNull ParameterInjectorRegistry<C> injectorRegistry() {
            return this.injectorRegistry;
        }

        public @NonNull AnnotationParser<C> annotationParser() {
            return this.annotationParser;
        }
    }
}

