/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandManager;
import cloud.commandframework.annotations.Flag;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.CommandFlag;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.parser.ParserParameters;
import cloud.commandframework.arguments.parser.ParserRegistry;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

final class FlagExtractor
implements Function<Method, Collection<CommandFlag<?>>> {
    private final CommandManager<?> commandManager;

    FlagExtractor(@NonNull CommandManager<?> commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public @NonNull Collection<@NonNull CommandFlag<?>> apply(@NonNull Method method) {
        LinkedList flags = new LinkedList();
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(Flag.class)) continue;
            Flag flag = parameter.getAnnotation(Flag.class);
            CommandFlag.Builder builder = this.commandManager.flagBuilder(flag.value()).withDescription(ArgumentDescription.of((String)flag.description())).withAliases(flag.aliases());
            if (parameter.getType().equals(Boolean.TYPE)) {
                flags.add(builder.build());
                continue;
            }
            ParserRegistry registry = this.commandManager.getParserRegistry();
            ArgumentParser parser = flag.parserName().isEmpty() ? (ArgumentParser)registry.createParser(TypeToken.get(parameter.getType()), ParserParameters.empty()).orElse(null) : (ArgumentParser)registry.createParser(flag.parserName(), ParserParameters.empty()).orElse(null);
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Cannot find parser for type '%s' for flag '%s' in method '%s'", parameter.getType().getCanonicalName(), flag.value(), method.getName()));
            }
            BiFunction suggestionProvider = !flag.suggestions().isEmpty() ? (BiFunction)registry.getSuggestionProvider(flag.suggestions()).orElse(null) : null;
            CommandArgument.Builder argumentBuilder0 = CommandArgument.ofType(parameter.getType(), (String)flag.value());
            CommandArgument.Builder argumentBuilder = argumentBuilder0.asRequired().manager(this.commandManager).withParser(parser);
            CommandArgument argument = suggestionProvider != null ? argumentBuilder.withSuggestionsProvider(suggestionProvider).build() : argumentBuilder.build();
            flags.add(builder.withArgument(argument).build());
        }
        return flags;
    }
}

