/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.annotations.AnnotationAccessor;
import cloud.commandframework.annotations.Argument;
import cloud.commandframework.annotations.ArgumentExtractor;
import cloud.commandframework.annotations.ArgumentMode;
import cloud.commandframework.annotations.ArgumentParameterPair;
import cloud.commandframework.annotations.CommandDescription;
import cloud.commandframework.annotations.CommandMethod;
import cloud.commandframework.annotations.CommandMethodPair;
import cloud.commandframework.annotations.CommandPermission;
import cloud.commandframework.annotations.Confirmation;
import cloud.commandframework.annotations.FlagExtractor;
import cloud.commandframework.annotations.Hidden;
import cloud.commandframework.annotations.MetaFactory;
import cloud.commandframework.annotations.MethodCommandExecutionHandler;
import cloud.commandframework.annotations.ProxiedBy;
import cloud.commandframework.annotations.Regex;
import cloud.commandframework.annotations.SyntaxFragment;
import cloud.commandframework.annotations.SyntaxParser;
import cloud.commandframework.annotations.injection.ParameterInjectorRegistry;
import cloud.commandframework.annotations.injection.RawArgs;
import cloud.commandframework.annotations.parsers.MethodArgumentParser;
import cloud.commandframework.annotations.parsers.Parser;
import cloud.commandframework.annotations.specifier.Completions;
import cloud.commandframework.annotations.suggestions.MethodSuggestionsProvider;
import cloud.commandframework.annotations.suggestions.Suggestions;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.CommandFlag;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.parser.ParserParameter;
import cloud.commandframework.arguments.parser.ParserParameters;
import cloud.commandframework.arguments.parser.StandardParameters;
import cloud.commandframework.arguments.preprocessor.RegexPreprocessor;
import cloud.commandframework.captions.Caption;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.extra.confirmation.CommandConfirmationManager;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.meta.SimpleCommandMeta;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AnnotationParser<C> {
    private final SyntaxParser syntaxParser = new SyntaxParser();
    private final ArgumentExtractor argumentExtractor = new ArgumentExtractor();
    private final CommandManager<C> manager;
    private final Map<Class<? extends Annotation>, Function<? extends Annotation, ParserParameters>> annotationMappers;
    private final Map<Class<? extends Annotation>, Function<? extends Annotation, BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>>> preprocessorMappers;
    private final Map<Class<? extends Annotation>, BiFunction<? extends Annotation, Command.Builder<C>, Command.Builder<C>>> builderModifiers;
    private final Class<C> commandSenderClass;
    private final MetaFactory metaFactory;
    private final FlagExtractor flagExtractor;

    public AnnotationParser(@NonNull CommandManager<C> manager, @NonNull Class<C> commandSenderClass, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.commandSenderClass = commandSenderClass;
        this.manager = manager;
        this.metaFactory = new MetaFactory(this, metaMapper);
        this.annotationMappers = new HashMap<Class<? extends Annotation>, Function<? extends Annotation, ParserParameters>>();
        this.preprocessorMappers = new HashMap<Class<? extends Annotation>, Function<? extends Annotation, BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>>>>();
        this.builderModifiers = new HashMap<Class<? extends Annotation>, BiFunction<? extends Annotation, Command.Builder<C>, Command.Builder<C>>>();
        this.flagExtractor = new FlagExtractor(manager);
        this.registerAnnotationMapper(CommandDescription.class, d -> ParserParameters.single((ParserParameter)StandardParameters.DESCRIPTION, (Object)d.value()));
        this.registerPreprocessorMapper(Regex.class, annotation -> RegexPreprocessor.of((String)annotation.value(), (Caption)Caption.of((String)annotation.failureCaption())));
        this.getParameterInjectorRegistry().registerInjector(String[].class, (context, annotations) -> annotations.annotation(RawArgs.class) == null ? null : context.getRawInput().toArray(new String[0]));
    }

    static <A extends Annotation> @Nullable A getAnnotationRecursively(@NonNull AnnotationAccessor annotations, @NonNull Class<A> clazz, @NonNull Set<Class<? extends Annotation>> checkedAnnotations) {
        A innerCandidate = null;
        for (Annotation annotation : annotations.annotations()) {
            A inner;
            if (!checkedAnnotations.add(annotation.annotationType())) continue;
            if (annotation.annotationType().equals(clazz)) {
                return (A)annotation;
            }
            if (annotation.annotationType().getPackage().getName().startsWith("java.lang") || (inner = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of(annotation.annotationType()), clazz, checkedAnnotations)) == null) continue;
            innerCandidate = inner;
        }
        return innerCandidate;
    }

    static <A extends Annotation> @Nullable A getMethodOrClassAnnotation(@NonNull Method method, @NonNull Class<A> clazz) {
        A annotation = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of((AnnotatedElement)method), clazz, new HashSet<Class<? extends Annotation>>());
        if (annotation == null) {
            annotation = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of(method.getDeclaringClass()), clazz, new HashSet<Class<? extends Annotation>>());
        }
        return annotation;
    }

    static <A extends Annotation> boolean methodOrClassHasAnnotation(@NonNull Method method, @NonNull Class<A> clazz) {
        return AnnotationParser.getMethodOrClassAnnotation(method, clazz) != null;
    }

    public <A extends Annotation> void registerBuilderModifier(@NonNull Class<A> annotation, @NonNull BiFunction<A, // Could not load outer class - annotation placement on inner may be incorrect
    Command.Builder<C>, // Could not load outer class - annotation placement on inner may be incorrect
    Command.Builder<C>> builderModifier) {
        this.builderModifiers.put(annotation, builderModifier);
    }

    public <A extends Annotation> void registerAnnotationMapper(@NonNull Class<A> annotation, @NonNull Function<@NonNull A, @NonNull ParserParameters> mapper) {
        this.annotationMappers.put(annotation, mapper);
    }

    public <A extends Annotation> void registerPreprocessorMapper(@NonNull Class<A> annotation, @NonNull Function<A, BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> preprocessorMapper) {
        this.preprocessorMappers.put(annotation, preprocessorMapper);
    }

    public @NonNull ParameterInjectorRegistry<C> getParameterInjectorRegistry() {
        return this.manager.parameterInjectorRegistry();
    }

    public <T> @NonNull Collection<@NonNull Command<C>> parse(@NonNull T instance) {
        this.parseSuggestions(instance);
        this.parseParsers(instance);
        Method[] methods = instance.getClass().getDeclaredMethods();
        ArrayList<CommandMethodPair> commandMethodPairs = new ArrayList<CommandMethodPair>();
        for (Method method : methods) {
            CommandMethod commandMethod = method.getAnnotation(CommandMethod.class);
            if (commandMethod == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException(String.format("@CommandMethod annotated method '%s' has non-void return type", method.getName()));
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(String.format("@CommandMethod annotated method '%s' is static! @CommandMethod annotated methods should not be static.", method.getName()));
            }
            commandMethodPairs.add(new CommandMethodPair(method, commandMethod));
        }
        Collection<Command<C>> commands = this.construct(instance, commandMethodPairs);
        for (Command<C> command : commands) {
            this.manager.command(command);
        }
        return commands;
    }

    private <T> void parseSuggestions(@NonNull T instance) {
        for (Method method : instance.getClass().getMethods()) {
            Suggestions suggestions = method.getAnnotation(Suggestions.class);
            if (suggestions == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!(method.getParameterCount() == 2 && method.getReturnType().equals(List.class) && method.getParameters()[0].getType().equals(CommandContext.class) && method.getParameters()[1].getType().equals(String.class))) {
                throw new IllegalArgumentException(String.format("@Suggestions annotated method '%s' in class '%s' does not have the correct signature", method.getName(), instance.getClass().getCanonicalName()));
            }
            try {
                this.manager.getParserRegistry().registerSuggestionProvider(suggestions.value(), new MethodSuggestionsProvider(instance, method));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void parseParsers(@NonNull T instance) {
        for (Method method : instance.getClass().getMethods()) {
            Parser parser = method.getAnnotation(Parser.class);
            if (parser == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (method.getParameterCount() != 2 || method.getReturnType().equals(Void.class) || !method.getParameters()[0].getType().equals(CommandContext.class) || !method.getParameters()[1].getType().equals(Queue.class)) {
                throw new IllegalArgumentException(String.format("@Parser annotated method '%s' in class '%s' does not have the correct signature", method.getName(), instance.getClass().getCanonicalName()));
            }
            try {
                BiFunction suggestionsProvider = parser.suggestions().isEmpty() ? (context, input) -> Collections.emptyList() : (BiFunction)this.manager.getParserRegistry().getSuggestionProvider(parser.suggestions()).orElseThrow(() -> new NullPointerException(String.format("Cannot find the suggestions provider with name '%s'", parser.suggestions())));
                MethodArgumentParser methodArgumentParser = new MethodArgumentParser(suggestionsProvider, instance, method);
                Function<ParserParameters, ArgumentParser> parserFunction = parameters -> methodArgumentParser;
                if (parser.name().isEmpty()) {
                    this.manager.getParserRegistry().registerParserSupplier(TypeToken.get((Type)method.getGenericReturnType()), parserFunction);
                    continue;
                }
                this.manager.getParserRegistry().registerNamedParserSupplier(parser.name(), parserFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private @NonNull Collection<@NonNull Command<C>> construct(@NonNull Object instance, @NonNull Collection<@NonNull CommandMethodPair> methodPairs) {
        ArrayList<Command<C>> commands = new ArrayList<Command<C>>();
        for (CommandMethodPair commandMethodPair : methodPairs) {
            void var18_19;
            CommandPermission commandPermission;
            CommandMethod commandMethod = commandMethodPair.getCommandMethod();
            Method method = commandMethodPair.getMethod();
            List<SyntaxFragment> tokens = this.syntaxParser.apply(commandMethod.value());
            String commandToken = commandMethod.value().split(" ")[0].split("\\|")[0];
            CommandManager<C> manager = this.manager;
            SimpleCommandMeta.Builder metaBuilder = SimpleCommandMeta.builder().with(this.metaFactory.apply(method));
            if (AnnotationParser.methodOrClassHasAnnotation(method, Confirmation.class)) {
                metaBuilder.with(CommandConfirmationManager.META_CONFIRMATION_REQUIRED, (Object)true);
            }
            Command.Builder<C> builder = manager.commandBuilder(commandToken, tokens.get(0).getMinor(), (CommandMeta)metaBuilder.build());
            Collection<ArgumentParameterPair> arguments = this.argumentExtractor.apply(method);
            Collection<CommandFlag<?>> flags = this.flagExtractor.apply(method);
            HashMap commandArguments = new HashMap();
            HashMap argumentDescriptions = new HashMap();
            for (ArgumentParameterPair argumentParameterPair : arguments) {
                CommandArgument<C, ?> argument = this.buildArgument(method, this.findSyntaxFragment(tokens, argumentParameterPair.getArgument().value()), argumentParameterPair);
                commandArguments.put(argument.getName(), argument);
                argumentDescriptions.put(argument, argumentParameterPair.getArgument().description());
            }
            boolean commandNameFound = false;
            for (Parameter[] token : tokens) {
                if (!commandNameFound) {
                    commandNameFound = true;
                    continue;
                }
                if (token.getArgumentMode() == ArgumentMode.LITERAL) {
                    builder = builder.literal(token.getMajor(), token.getMinor().toArray(new String[0]));
                    continue;
                }
                CommandArgument argument = (CommandArgument)commandArguments.get(token.getMajor());
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Found no mapping for argument '%s' in method '%s'", token.getMajor(), method.getName()));
                }
                String description = argumentDescriptions.getOrDefault(argument, "");
                builder = builder.argument(argument, ArgumentDescription.of((String)description));
            }
            Object var18_23 = null;
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isAnnotationPresent(Argument.class) || !this.commandSenderClass.isAssignableFrom(parameter.getType())) continue;
                Class<?> clazz = parameter.getType();
                break;
            }
            if ((commandPermission = AnnotationParser.getMethodOrClassAnnotation(method, CommandPermission.class)) != null) {
                builder = builder.permission(commandPermission.value());
            }
            if (commandMethod.requiredSender() != Object.class) {
                builder = builder.senderType(commandMethod.requiredSender());
            } else if (var18_19 != null) {
                builder = builder.senderType((Class)var18_19);
            }
            try {
                MethodCommandExecutionHandler commandExecutionHandler = new MethodCommandExecutionHandler(instance, commandArguments, method, this.getParameterInjectorRegistry());
                builder = builder.handler(commandExecutionHandler);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to construct command execution handler", e);
            }
            if (AnnotationParser.methodOrClassHasAnnotation(method, Hidden.class)) {
                builder = builder.hidden();
            }
            for (CommandFlag<?> flag : flags) {
                builder = builder.flag(flag);
            }
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                BiFunction<Annotation, Command.Builder<C>, Command.Builder<C>> builderModifier = this.builderModifiers.get(annotation.annotationType());
                if (builderModifier == null) continue;
                builder = builderModifier.apply(annotation, builder);
            }
            Command builtCommand = builder.build();
            commands.add(builtCommand);
            if (!method.isAnnotationPresent(ProxiedBy.class)) continue;
            ProxiedBy proxyAnnotation = method.getAnnotation(ProxiedBy.class);
            String proxy = proxyAnnotation.value();
            if (proxy.contains(" ")) {
                throw new IllegalArgumentException("@ProxiedBy proxies may only contain single literals");
            }
            Command.Builder proxyBuilder = manager.commandBuilder(proxy, builtCommand.getCommandMeta(), new String[0]).proxies(builtCommand);
            if (proxyAnnotation.hidden()) {
                proxyBuilder = proxyBuilder.hidden();
            }
            manager.command(proxyBuilder.build());
        }
        return commands;
    }

    private @NonNull SyntaxFragment findSyntaxFragment(@NonNull List<@NonNull SyntaxFragment> fragments, @NonNull String argumentName) {
        for (SyntaxFragment fragment : fragments) {
            if (fragment.getArgumentMode() == ArgumentMode.LITERAL || !fragment.getMajor().equals(argumentName)) continue;
            return fragment;
        }
        throw new IllegalArgumentException("Argument is not declared in syntax: " + argumentName);
    }

    private @NonNull CommandArgument<C, ?> buildArgument(@NonNull Method method, @Nullable SyntaxFragment syntaxFragment, @NonNull ArgumentParameterPair argumentPair) {
        Parameter parameter = argumentPair.getParameter();
        List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
        TypeToken token = TypeToken.get((Type)parameter.getParameterizedType());
        ParserParameters parameters = this.manager.getParserRegistry().parseAnnotations(token, annotations);
        ArgumentParser parser = argumentPair.getArgument().parserName().isEmpty() ? (ArgumentParser)this.manager.getParserRegistry().createParser(token, parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' in method '%s' has parser '%s' but no parser exists for that type", parameter.getName(), method.getName(), token.getType().getTypeName()))) : (ArgumentParser)this.manager.getParserRegistry().createParser(argumentPair.getArgument().parserName(), parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' in method '%s' has parser '%s' but no parser exists for that type", parameter.getName(), method.getName(), token.getType().getTypeName())));
        if (syntaxFragment == null || syntaxFragment.getArgumentMode() == ArgumentMode.LITERAL) {
            throw new IllegalArgumentException(String.format("Invalid command argument '%s' in method '%s': Missing syntax mapping", argumentPair.getArgument().value(), method.getName()));
        }
        Argument argument = argumentPair.getArgument();
        CommandArgument.Builder argumentBuilder = CommandArgument.ofType(parameter.getType(), (String)argument.value());
        if (syntaxFragment.getArgumentMode() == ArgumentMode.OPTIONAL) {
            if (argument.defaultValue().isEmpty()) {
                argumentBuilder.asOptional();
            } else {
                argumentBuilder.asOptionalWithDefault(argument.defaultValue());
            }
        } else {
            argumentBuilder.asRequired();
        }
        Completions completions = parameter.getDeclaredAnnotation(Completions.class);
        if (completions != null) {
            List<String> suggestions = Arrays.asList(completions.value().replace(" ", "").split(","));
            argumentBuilder.withSuggestionsProvider((commandContext, input) -> suggestions);
        } else if (!argument.suggestions().isEmpty()) {
            String suggestionProviderName = argument.suggestions();
            Optional suggestionsFunction = this.manager.getParserRegistry().getSuggestionProvider(suggestionProviderName);
            argumentBuilder.withSuggestionsProvider((BiFunction)suggestionsFunction.orElseThrow(() -> new IllegalArgumentException(String.format("There is no suggestion provider with name '%s'. Did you forget to register it?", suggestionProviderName))));
        }
        CommandArgument builtArgument = argumentBuilder.manager(this.manager).withParser(parser).build();
        for (Annotation annotation : annotations) {
            Function<Annotation, BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>>> preprocessorMapper = this.preprocessorMappers.get(annotation.annotationType());
            if (preprocessorMapper == null) continue;
            BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>> preprocessor = preprocessorMapper.apply(annotation);
            builtArgument.addPreprocessor(preprocessor);
        }
        return builtArgument;
    }

    @NonNull Map<@NonNull Class<@NonNull ? extends Annotation>, @NonNull Function<@NonNull ? extends Annotation, @NonNull ParserParameters>> getAnnotationMappers() {
        return this.annotationMappers;
    }
}

