/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.utils;

import ch.jalu.injector.annotations.NoFieldScan;
import ch.jalu.injector.annotations.NoMethodScan;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.exceptions.InjectorReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getFieldValue(Field field, Object instance) {
        field.setAccessible(true);
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InjectorReflectionException("Could not get value of field '" + field.getName() + "' for " + instance, e);
        }
    }

    public static void setField(Field field, Object instance, Object value) {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InjectorReflectionException("Could not set field '" + field.getName() + "' for " + instance, e);
        }
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        method.setAccessible(true);
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InjectorReflectionException("Could not invoke method '" + method.getName() + "' for " + instance, e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InjectorReflectionException("Could not invoke constructor of class '" + constructor.getDeclaringClass() + "'", e);
        }
    }

    @Nullable
    public static Class<?> getGenericType(@Nullable Type genericType) {
        Type[] types;
        if (genericType != null && genericType instanceof ParameterizedType && (types = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0 && types[0] instanceof Class) {
            return (Class)types[0];
        }
        return null;
    }

    @Nullable
    public static Class<?> getCollectionType(Class<?> mainType, @Nullable Type genericType) {
        if (mainType.isArray()) {
            return mainType.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(mainType)) {
            return ReflectionUtils.getGenericType(genericType);
        }
        return null;
    }

    public static <T> Object toSuitableCollectionType(Class<?> rawType, Set<T> result) {
        if (rawType.isArray()) {
            Class<Set> arrayClass = rawType;
            return Arrays.copyOf(result.toArray(), result.size(), arrayClass);
        }
        if (rawType.isAssignableFrom(Set.class)) {
            return result;
        }
        if (rawType.isAssignableFrom(List.class)) {
            return new ArrayList<T>(result);
        }
        throw new InjectorException("Cannot convert @AllTypes result to '" + rawType + "'. Supported: Set, List, or any supertype thereof, and array");
    }

    public static Method[] safeGetDeclaredMethods(Class<?> clazz) {
        return clazz.isAnnotationPresent(NoMethodScan.class) ? new Method[]{} : clazz.getDeclaredMethods();
    }

    public static Field[] safeGetDeclaredFields(Class<?> clazz) {
        return clazz.isAnnotationPresent(NoFieldScan.class) ? new Field[]{} : clazz.getDeclaredFields();
    }
}

