/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.testing.runner;

import ch.jalu.injector.Injector;
import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.handlers.instantiation.SimpleResolution;
import ch.jalu.injector.testing.InjectDelayed;
import ch.jalu.injector.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.Set;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;
import org.mockito.Mock;

public class MockDependencyHandler
implements Handler {
    private final TestClass testClass;
    private final Object target;
    private boolean areMocksRegistered;
    private Set<Class<?>> fieldsToInject;

    public MockDependencyHandler(TestClass testClass, Object target) {
        this.testClass = testClass;
        this.target = target;
    }

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        Class<?> type;
        Object object;
        Injector injector = context.getInjector();
        if (!this.areMocksRegistered) {
            this.registerAllMocks(injector);
            this.areMocksRegistered = true;
        }
        if ((object = injector.getIfAvailable(type = context.getIdentifier().getTypeAsClass())) != null) {
            return new SimpleResolution(object);
        }
        if (this.fieldsToInject.contains(type)) {
            return null;
        }
        throw new InjectorException("No mock found for '" + type + "'. All dependencies of @InjectDelayed must be provided as @Mock or @InjectDelayed fields");
    }

    private void registerAllMocks(Injector injector) {
        for (FrameworkField frameworkField : this.testClass.getAnnotatedFields(Mock.class)) {
            Class clazz = frameworkField.getType();
            injector.register(clazz, ReflectionUtils.getFieldValue(frameworkField.getField(), this.target));
        }
        this.fieldsToInject = new HashSet();
        for (FrameworkField frameworkField : this.testClass.getAnnotatedFields(InjectDelayed.class)) {
            this.fieldsToInject.add(frameworkField.getType());
        }
    }
}

