/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.postconstruct;

import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;

public class PostConstructMethodInvoker
implements Handler {
    @Override
    public <T> T postProcess(T object, ResolutionContext context, Resolution<?> resolution) {
        Class<?> clazz = object.getClass();
        List<Method> postConstructMethods = PostConstructMethodInvoker.getPostConstructMethods(clazz);
        for (int i = postConstructMethods.size() - 1; i >= 0; --i) {
            ReflectionUtils.invokeMethod(postConstructMethods.get(i), object, new Object[0]);
        }
        return null;
    }

    private static List<Method> getPostConstructMethods(Class<?> clazz) {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method postConstruct = PostConstructMethodInvoker.getAndValidatePostConstructMethod(currentClass);
            if (postConstruct == null) continue;
            postConstructMethods.add(postConstruct);
        }
        return postConstructMethods;
    }

    @Nullable
    private static Method getAndValidatePostConstructMethod(Class<?> clazz) {
        Method postConstructMethod = null;
        for (Method method : ReflectionUtils.safeGetDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstructMethod != null) {
                throw new InjectorException("Multiple methods with @PostConstruct in " + clazz);
            }
            if (method.getParameterTypes().length > 0 || Modifier.isStatic(method.getModifiers())) {
                throw new InjectorException("@PostConstruct method may not be static or have any parameters. Invalid method in " + clazz);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new InjectorException("@PostConstruct method must have return type void. Offending class: " + clazz);
            }
            postConstructMethod = method;
        }
        return postConstructMethod;
    }
}

