/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.instantiation;

import ch.jalu.injector.context.ObjectIdentifier;
import ch.jalu.injector.context.StandardResolutionType;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.utils.InjectorUtils;
import ch.jalu.injector.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StandardInjection<T>
implements Resolution<T> {
    private final Constructor<T> constructor;
    private final List<Field> fields;
    private SoftReference<List<ObjectIdentifier>> dependencies;

    public StandardInjection(Constructor<T> constructor, List<Field> fields) {
        this.constructor = constructor;
        this.fields = fields;
    }

    @Override
    public List<ObjectIdentifier> getDependencies() {
        List<ObjectIdentifier> depList;
        List<ObjectIdentifier> list = depList = this.dependencies == null ? null : this.dependencies.get();
        if (depList == null) {
            List<ObjectIdentifier> constructorDeps = this.buildConstructorDependencies();
            List<ObjectIdentifier> fieldDeps = this.buildFieldDependencies();
            depList = new ArrayList<ObjectIdentifier>(constructorDeps.size() + fieldDeps.size());
            depList.addAll(constructorDeps);
            depList.addAll(fieldDeps);
            this.dependencies = new SoftReference<List<ObjectIdentifier>>(depList);
        }
        return depList;
    }

    @Override
    public T instantiateWith(Object ... values) {
        InjectorUtils.checkArgument(values.length == this.constructor.getParameterTypes().length + this.fields.size(), "Number of values does not correspond to the expected number");
        int constructorParams = this.constructor.getParameterTypes().length;
        List<Object> constructorValues = Arrays.asList(values).subList(0, constructorParams);
        T instance = ReflectionUtils.newInstance(this.constructor, constructorValues.toArray());
        for (int i = 0; i < this.fields.size(); ++i) {
            ReflectionUtils.setField(this.fields.get(i), instance, values[i + constructorParams]);
        }
        return instance;
    }

    @Override
    public boolean isInstantiation() {
        return true;
    }

    private List<ObjectIdentifier> buildConstructorDependencies() {
        Type[] parameters = this.constructor.getGenericParameterTypes();
        Annotation[][] annotations = this.constructor.getParameterAnnotations();
        ArrayList<ObjectIdentifier> dependencies = new ArrayList<ObjectIdentifier>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            dependencies.add(new ObjectIdentifier(StandardResolutionType.SINGLETON, parameters[i], annotations[i]));
        }
        return dependencies;
    }

    private List<ObjectIdentifier> buildFieldDependencies() {
        return this.fields.stream().map(f -> new ObjectIdentifier(StandardResolutionType.SINGLETON, f.getGenericType(), f.getAnnotations())).collect(Collectors.toList());
    }
}

