/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.instantiation;

import ch.jalu.injector.context.ObjectIdentifier;
import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.context.StandardResolutionType;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.handlers.instantiation.SimpleResolution;
import ch.jalu.injector.utils.InjectorUtils;
import ch.jalu.injector.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ProviderHandler
implements Handler {
    protected Map<Class<?>, ProviderBasedInstantiation<?>> providers = new HashMap();

    @Override
    public <T> void onProvider(Class<T> clazz, Provider<? extends T> provider) {
        InjectorUtils.checkArgument(!this.providers.containsKey(clazz), "Provider already registered for " + clazz);
        this.providers.put(clazz, new InstantiationByProvider<T>(provider));
    }

    @Override
    public <T, P extends Provider<? extends T>> void onProviderClass(Class<T> clazz, Class<P> providerClass) {
        InjectorUtils.checkArgument(!this.providers.containsKey(clazz), "Provider already registered for " + clazz);
        this.providers.put(clazz, new InstantiationByProviderClass(providerClass));
    }

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        if (Provider.class.equals(context.getIdentifier().getTypeAsClass())) {
            return this.handleProviderRequest(context);
        }
        return this.providers.get(context.getIdentifier().getTypeAsClass());
    }

    @Nullable
    private Resolution<?> handleProviderRequest(ResolutionContext context) {
        Class<?> genericType = ReflectionUtils.getGenericType(context.getIdentifier().getType());
        if (genericType == null) {
            throw new InjectorException("Injection of a provider was requested but no generic type was given");
        }
        ProviderBasedInstantiation<?> givenInstantiation = this.providers.get(genericType);
        if (givenInstantiation == null) {
            Provider defaultProvider = () -> context.getInjector().newInstance(genericType);
            return new SimpleResolution<Provider>(defaultProvider);
        }
        return givenInstantiation.createProviderResolution();
    }

    private static final class InstantiationByProviderClass<T>
    implements ProviderBasedInstantiation<T> {
        private final Class<? extends Provider<? extends T>> providerClass;

        InstantiationByProviderClass(Class<? extends Provider<? extends T>> providerClass) {
            this.providerClass = providerClass;
        }

        @Override
        public List<ObjectIdentifier> getDependencies() {
            return Collections.singletonList(new ObjectIdentifier(StandardResolutionType.SINGLETON, this.providerClass, new Annotation[0]));
        }

        @Override
        public T instantiateWith(Object ... values) {
            InjectorUtils.checkArgument(values.length == 1 && this.providerClass.isInstance(values[0]), "Expected one dependency of type " + this.providerClass);
            return (T)((Provider)values[0]).get();
        }

        @Override
        public boolean isInstantiation() {
            return true;
        }

        @Override
        public Resolution<Provider<? extends T>> createProviderResolution() {
            return new Resolution<Provider<? extends T>>(){

                @Override
                public List<ObjectIdentifier> getDependencies() {
                    return Collections.singletonList(new ObjectIdentifier(StandardResolutionType.SINGLETON, providerClass, new Annotation[0]));
                }

                @Override
                public Provider<? extends T> instantiateWith(Object ... values) {
                    InjectorUtils.checkArgument(values.length == 1 && providerClass.isInstance(values[0]), "Expected one dependency of type " + providerClass);
                    return (Provider)values[0];
                }
            };
        }
    }

    private static final class InstantiationByProvider<T>
    implements ProviderBasedInstantiation<T> {
        private final Provider<? extends T> provider;

        InstantiationByProvider(Provider<? extends T> provider) {
            this.provider = provider;
        }

        @Override
        public List<ObjectIdentifier> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public T instantiateWith(Object ... values) {
            InjectorUtils.checkArgument(values.length == 0, "No dependencies expected");
            return (T)this.provider.get();
        }

        @Override
        public boolean isInstantiation() {
            return true;
        }

        @Override
        public Resolution<Provider<? extends T>> createProviderResolution() {
            return new SimpleResolution<Provider<? extends T>>(this.provider);
        }
    }

    private static interface ProviderBasedInstantiation<T>
    extends Resolution<T> {
        public Resolution<Provider<? extends T>> createProviderResolution();
    }
}

