/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.dependency;

import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.handlers.instantiation.SimpleResolution;
import ch.jalu.injector.utils.InjectorUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class SavedAnnotationsHandler
implements Handler {
    private Map<Class<?>, Object> storedValues = new HashMap();

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        for (Annotation annotation : context.getIdentifier().getAnnotations()) {
            Object o = this.storedValues.get(annotation.annotationType());
            if (o == null) continue;
            return new SimpleResolution<Object>(o);
        }
        return null;
    }

    @Override
    public void onAnnotation(Class<? extends Annotation> annotation, Object object) {
        InjectorUtils.checkNotNull(object, "Object may not be null");
        if (this.storedValues.containsKey(annotation)) {
            throw new InjectorException("Value already registered for @" + annotation.getSimpleName());
        }
        this.storedValues.put(annotation, object);
    }
}

