/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.dependency;

import ch.jalu.injector.context.ObjectIdentifier;
import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CyclicDependenciesDetector
implements Handler {
    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        ObjectIdentifier duplicateIdentifier = CyclicDependenciesDetector.findRepeatedIdentifier(context);
        if (duplicateIdentifier != null) {
            String traversalList = CyclicDependenciesDetector.buildParentsList(context);
            throw new InjectorException("Found cyclic dependency' - already traversed '" + duplicateIdentifier + "' (full traversal list: " + traversalList + " -> " + context.getIdentifier() + ")");
        }
        return null;
    }

    @Nullable
    private static ObjectIdentifier findRepeatedIdentifier(ResolutionContext context) {
        HashSet<Type> types = new HashSet<Type>();
        types.add(context.getIdentifier().getType());
        for (ResolutionContext parent : context.getParents()) {
            if (types.add(parent.getIdentifier().getType())) continue;
            return parent.getIdentifier();
        }
        return null;
    }

    private static String buildParentsList(ResolutionContext context) {
        return context.getParents().stream().map(ctx -> ctx.getIdentifier().getType().getTypeName()).collect(Collectors.joining(" -> "));
    }
}

