/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector;

import ch.jalu.injector.Injector;
import ch.jalu.injector.InjectorConfig;
import ch.jalu.injector.context.ObjectIdentifier;
import ch.jalu.injector.context.ResolutionContext;
import ch.jalu.injector.context.ResolutionType;
import ch.jalu.injector.context.StandardResolutionType;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.Handler;
import ch.jalu.injector.handlers.instantiation.Resolution;
import ch.jalu.injector.utils.InjectorUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class InjectorImpl
implements Injector {
    protected Map<Class<?>, Object> objects;
    protected InjectorConfig config;

    protected InjectorImpl(InjectorConfig config) {
        this.config = config;
        this.objects = new HashMap();
        this.objects.put(Injector.class, this);
    }

    @Override
    public <T> void register(Class<? super T> clazz, T object) {
        if (this.objects.containsKey(clazz)) {
            throw new InjectorException("There is already an object present for " + clazz);
        }
        InjectorUtils.checkNotNull(object);
        this.objects.put(clazz, object);
    }

    @Override
    public void provide(Class<? extends Annotation> clazz, Object object) {
        InjectorUtils.checkNotNull(clazz, "Provided annotation may not be null");
        try {
            for (Handler handler : this.config.getHandlers()) {
                handler.onAnnotation(clazz, object);
            }
        }
        catch (Exception e) {
            InjectorUtils.rethrowException(e);
        }
    }

    @Override
    public <T> T getSingleton(Class<T> clazz) {
        return this.resolve(StandardResolutionType.SINGLETON, clazz);
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        return this.resolve(StandardResolutionType.REQUEST_SCOPED, clazz);
    }

    @Override
    public <T> T getIfAvailable(Class<T> clazz) {
        return clazz.cast(this.objects.get(clazz));
    }

    @Override
    public <T> T createIfHasDependencies(Class<T> clazz) {
        return this.resolve(StandardResolutionType.REQUEST_SCOPED_IF_HAS_DEPENDENCIES, clazz);
    }

    @Override
    public <T> Collection<T> retrieveAllOfType(Class<T> clazz) {
        ArrayList<T> instances = new ArrayList<T>();
        for (Object object : this.objects.values()) {
            if (!clazz.isInstance(object)) continue;
            instances.add(clazz.cast(object));
        }
        return instances;
    }

    @Override
    public <T> void registerProvider(Class<T> clazz, Provider<? extends T> provider) {
        InjectorUtils.checkNotNull(clazz, "Class may not be null");
        InjectorUtils.checkNotNull(provider, "Provider may not be null");
        try {
            for (Handler handler : this.config.getHandlers()) {
                handler.onProvider(clazz, provider);
            }
        }
        catch (Exception e) {
            InjectorUtils.rethrowException(e);
        }
    }

    @Override
    public <T, P extends Provider<? extends T>> void registerProvider(Class<T> clazz, Class<P> providerClass) {
        InjectorUtils.checkNotNull(clazz, "Class may not be null");
        InjectorUtils.checkNotNull(providerClass, "Provider class may not be null");
        try {
            for (Handler handler : this.config.getHandlers()) {
                handler.onProviderClass(clazz, providerClass);
            }
        }
        catch (Exception e) {
            InjectorUtils.rethrowException(e);
        }
    }

    public InjectorConfig getConfig() {
        return this.config;
    }

    private <T> T resolve(ResolutionType resolutionType, Class<?> clazz) {
        return (T)this.resolveContext(new ResolutionContext(this, new ObjectIdentifier(resolutionType, clazz, new Annotation[0])));
    }

    @Nullable
    protected Object resolveContext(ResolutionContext context) {
        Object knownSingleton;
        if (context.getIdentifier().getResolutionType() == StandardResolutionType.SINGLETON && (knownSingleton = this.objects.get(context.getIdentifier().getTypeAsClass())) != null) {
            return knownSingleton;
        }
        Resolution<?> resolution = this.findResolutionOrFail(context);
        if (InjectorImpl.isContextChildOfOptionalRequest(context) && resolution.isInstantiation()) {
            return null;
        }
        Object[] resolvedDependencies = this.resolveDependencies(context, resolution);
        if (InjectorUtils.containsNullValue(resolvedDependencies)) {
            this.throwForUnexpectedNullDependency(context);
            return null;
        }
        Object object = this.runPostConstructHandlers(resolution.instantiateWith(resolvedDependencies), context, resolution);
        if (resolution.isInstantiation() && context.getIdentifier().getResolutionType() == StandardResolutionType.SINGLETON) {
            this.register(context.getOriginalIdentifier().getTypeAsClass(), object);
        }
        return object;
    }

    protected Object[] resolveDependencies(ResolutionContext context, Resolution<?> resolution) {
        ObjectIdentifier dependencyId;
        Object dependency;
        int totalDependencies = resolution.getDependencies().size();
        Object[] resolvedDependencies = new Object[totalDependencies];
        int index = 0;
        Iterator<ObjectIdentifier> iterator = resolution.getDependencies().iterator();
        while (iterator.hasNext() && (dependency = this.resolveContext(context.createChildContext(dependencyId = iterator.next()))) != null) {
            resolvedDependencies[index] = dependency;
            ++index;
        }
        return resolvedDependencies;
    }

    protected void throwForUnexpectedNullDependency(ResolutionContext context) {
        if (context.getIdentifier().getResolutionType() == StandardResolutionType.REQUEST_SCOPED_IF_HAS_DEPENDENCIES || InjectorImpl.isContextChildOfOptionalRequest(context)) {
            return;
        }
        throw new InjectorException("Found null returned as dependency while resolving '" + context.getIdentifier() + "'");
    }

    private static boolean isContextChildOfOptionalRequest(ResolutionContext context) {
        return !context.getParents().isEmpty() && context.getParents().get(0).getIdentifier().getResolutionType() == StandardResolutionType.REQUEST_SCOPED_IF_HAS_DEPENDENCIES;
    }

    protected Resolution<?> findResolutionOrFail(ResolutionContext context) {
        try {
            for (Handler handler : this.config.getHandlers()) {
                Resolution<?> resolution = handler.resolve(context);
                if (resolution == null) continue;
                return resolution;
            }
        }
        catch (Exception e) {
            InjectorUtils.rethrowException(e);
        }
        Class<?> clazz = context.getIdentifier().getTypeAsClass();
        if (!InjectorUtils.canInstantiate(clazz)) {
            String hint = clazz.isPrimitive() ? "Primitive types must be provided by default. " : (clazz.isArray() ? "By default, arrays cannot be injected. " : "");
            throw new InjectorException(String.format("Did not find instantiation method for '%s'. %sThis class cannot be instantiated; please check the class or your handlers.", clazz, hint));
        }
        throw new InjectorException("Did not find instantiation method for '" + context.getIdentifier().getTypeAsClass() + "'. Make sure your class conforms to one of the registered instantiations. If default: make sure you have a constructor with @Inject or fields with @Inject. Fields with @Inject require the default constructor");
    }

    protected <T> T runPostConstructHandlers(T instance, ResolutionContext context, Resolution<?> resolution) {
        if (!resolution.isInstantiation()) {
            return instance;
        }
        T object = instance;
        try {
            for (Handler handler : this.config.getHandlers()) {
                object = InjectorUtils.firstNotNull(handler.postProcess(object, context, resolution), object);
            }
        }
        catch (Exception e) {
            InjectorUtils.rethrowException(e);
        }
        return object;
    }
}

