/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.utils;

import ch.jalu.injector.exceptions.InjectorException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class InjectorUtils {
    private InjectorUtils() {
    }

    public static void checkNotNull(Object o) {
        InjectorUtils.checkNotNull(o, "Object may not be null");
    }

    public static void checkNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new InjectorException(errorMessage);
        }
    }

    @SafeVarargs
    public static <T> void checkNoNullValues(T ... arr) {
        InjectorUtils.checkNotNull(arr);
        for (T o : arr) {
            InjectorUtils.checkNotNull(o);
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new InjectorException(errorMessage);
        }
    }

    public static void rethrowException(Exception e) throws InjectorException {
        throw e instanceof InjectorException ? (InjectorException)e : new InjectorException("An error occurred (see cause)", e);
    }

    @Nullable
    public static <T> T firstNotNull(T obj1, T obj2) {
        return obj1 == null ? obj2 : obj1;
    }

    public static boolean canInstantiate(Class<?> clazz) {
        return !clazz.isEnum() && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static String getDeclarer(@Nullable Member member) {
        return member == null ? "null" : member.getDeclaringClass().getName();
    }

    public static <A extends AccessibleObject> boolean isInjectAnnotationPresent(A[] accessibles) {
        for (A accessible : accessibles) {
            if (!((AccessibleObject)accessible).isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }
}

