/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.instantiation;

import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.instantiation.DirectInstantiationProvider;
import ch.jalu.injector.handlers.instantiation.FieldInjection;
import ch.jalu.injector.utils.InjectorUtils;
import ch.jalu.injector.utils.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class FieldInjectionProvider
extends DirectInstantiationProvider {
    protected <T> FieldInjection<T> safeGet(Class<T> clazz) {
        Constructor<T> constructor = FieldInjectionProvider.getNoArgsConstructor(clazz);
        if (constructor == null) {
            return null;
        }
        List<Field> fields = FieldInjectionProvider.getInjectionFields(clazz);
        if (fields.isEmpty()) {
            return null;
        }
        FieldInjectionProvider.validateHasNoOtherInjectAnnotations(clazz);
        return new FieldInjection<T>(constructor, fields);
    }

    private static List<Field> getInjectionFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ReflectionUtils.safeGetDeclaredFields(clazz)) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                throw new InjectorException(String.format("Field '%s' in class '%s' is static but annotated with @Inject", field.getName(), clazz.getSimpleName()));
            }
            fields.add(field);
        }
        return fields;
    }

    private static void validateHasNoOtherInjectAnnotations(Class<?> clazz) {
        if (InjectorUtils.isInjectAnnotationPresent((AccessibleObject[])clazz.getDeclaredConstructors()) || InjectorUtils.isInjectAnnotationPresent((AccessibleObject[])ReflectionUtils.safeGetDeclaredMethods(clazz))) {
            throw new InjectorException("Class '" + clazz + "' may not have @Inject on fields AND on other members. " + "Remove other @Inject uses or remove it from the fields");
        }
    }

    private static <T> Constructor<T> getNoArgsConstructor(Class<T> clazz) {
        try {
            Constructor<T> noArgsConstructor = clazz.getDeclaredConstructor(new Class[0]);
            noArgsConstructor.setAccessible(true);
            return noArgsConstructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

