/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.instantiation;

import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.instantiation.ConstructorInjection;
import ch.jalu.injector.handlers.instantiation.DirectInstantiationProvider;
import ch.jalu.injector.utils.InjectorUtils;
import ch.jalu.injector.utils.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import javax.inject.Inject;

public class ConstructorInjectionProvider
extends DirectInstantiationProvider {
    protected <T> ConstructorInjection<T> safeGet(Class<T> clazz) {
        Constructor<T> constructor = ConstructorInjectionProvider.getInjectionConstructor(clazz);
        if (constructor == null) {
            return null;
        }
        ConstructorInjectionProvider.validateHasNoOtherInjectAnnotations(clazz);
        return new ConstructorInjection<T>(constructor);
    }

    private static <T> Constructor<T> getInjectionConstructor(Class<T> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            return constructor;
        }
        return null;
    }

    private static void validateHasNoOtherInjectAnnotations(Class<?> clazz) {
        if (InjectorUtils.isInjectAnnotationPresent((AccessibleObject[])ReflectionUtils.safeGetDeclaredFields(clazz)) || InjectorUtils.isInjectAnnotationPresent((AccessibleObject[])ReflectionUtils.safeGetDeclaredMethods(clazz))) {
            throw new InjectorException("Class '" + clazz + "' may not have @Inject on a constructor AND " + "on other members. Remove other @Inject uses or remove it from the constructor");
        }
    }
}

