/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.dependency;

import ch.jalu.injector.Injector;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.annotationvalues.AnnotationValueHandler;
import ch.jalu.injector.handlers.dependency.DependencyHandler;
import ch.jalu.injector.handlers.instantiation.DependencyDescription;
import ch.jalu.injector.utils.InjectorUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class SavedAnnotationsHandler
implements DependencyHandler,
AnnotationValueHandler {
    private Map<Class<?>, Object> storedValues = new HashMap();

    @Override
    public Object resolveValue(Injector injector, DependencyDescription dependencyDescription) {
        for (Annotation annotation : dependencyDescription.getAnnotations()) {
            Object o = this.storedValues.get(annotation.annotationType());
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void processProvided(Class<? extends Annotation> annotation, Object object) {
        InjectorUtils.checkNotNull(object, "Object may not be null");
        if (this.storedValues.containsKey(annotation)) {
            throw new InjectorException("Value already registered for @" + annotation.getSimpleName());
        }
        this.storedValues.put(annotation, object);
    }
}

