/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector.handlers.dependency;

import ch.jalu.injector.Injector;
import ch.jalu.injector.annotations.AllInstances;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.dependency.TypeSafeAnnotationHandler;
import ch.jalu.injector.handlers.instantiation.DependencyDescription;
import ch.jalu.injector.utils.InjectorUtils;
import ch.jalu.injector.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class AllInstancesAnnotationHandler
extends TypeSafeAnnotationHandler<AllInstances> {
    private Reflections reflections;

    public AllInstancesAnnotationHandler(String rootPackage) {
        this.reflections = new Reflections(rootPackage, new Scanner[0]);
    }

    @Override
    public Class<AllInstances> getAnnotationType() {
        return AllInstances.class;
    }

    @Override
    public Object resolveValueSafely(Injector injector, AllInstances annotation, DependencyDescription dependencyDescription) {
        Class<?> rawType = dependencyDescription.getType();
        Class<?> genericType = ReflectionUtils.getCollectionType(rawType, dependencyDescription.getGenericType());
        if (genericType == null) {
            throw new InjectorException("Unsupported dependency of type '" + rawType + "' annotated with @AllInstances. (Or did you forget the generic type?)");
        }
        Set subTypes = this.reflections.getSubTypesOf(genericType);
        HashSet instances = new HashSet(subTypes.size());
        for (Class type : subTypes) {
            if (!InjectorUtils.canInstantiate(type)) continue;
            instances.add(injector.getSingleton(type));
        }
        return ReflectionUtils.toSuitableCollectionType(rawType, instances);
    }
}

