/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.injector;

import ch.jalu.injector.Injector;
import ch.jalu.injector.InjectorConfig;
import ch.jalu.injector.exceptions.InjectorException;
import ch.jalu.injector.handlers.annotationvalues.AnnotationValueHandler;
import ch.jalu.injector.handlers.dependency.DependencyHandler;
import ch.jalu.injector.handlers.instantiation.DependencyDescription;
import ch.jalu.injector.handlers.instantiation.Instantiation;
import ch.jalu.injector.handlers.instantiation.InstantiationProvider;
import ch.jalu.injector.handlers.postconstruct.PostConstructHandler;
import ch.jalu.injector.handlers.preconstruct.PreConstructHandler;
import ch.jalu.injector.handlers.provider.ProviderHandler;
import ch.jalu.injector.utils.InjectorUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class InjectorImpl
implements Injector {
    protected final Map<Class<?>, Object> objects;
    protected InjectorConfig config;

    protected InjectorImpl(InjectorConfig config) {
        this.config = config;
        this.objects = new HashMap();
        this.objects.put(Injector.class, this);
    }

    @Override
    public <T> T getSingleton(Class<T> clazz) {
        return this.get(clazz, new HashSet());
    }

    @Override
    public <T> void register(Class<? super T> clazz, T object) {
        if (this.objects.containsKey(clazz)) {
            throw new InjectorException("There is already an object present for " + clazz);
        }
        InjectorUtils.checkNotNull(object);
        this.objects.put(clazz, object);
    }

    @Override
    public void provide(Class<? extends Annotation> clazz, Object object) {
        InjectorUtils.checkNotNull(clazz, "Provided annotation may not be null");
        for (AnnotationValueHandler annotationValueHandler : this.config.getAnnotationValueHandlers()) {
            try {
                annotationValueHandler.processProvided(clazz, object);
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        Class mappedClass = this.processPreConstructorHandlers(clazz);
        return (T)this.instantiate(mappedClass, new HashSet());
    }

    @Override
    public <T> T getIfAvailable(Class<T> clazz) {
        return clazz.cast(this.objects.get(clazz));
    }

    @Override
    public <T> T createIfHasDependencies(Class<T> clazz) {
        Class mappedClass = this.processPreConstructorHandlers(clazz);
        Instantiation instantiation = this.getInstantiation(mappedClass);
        ArrayList<Object> dependencies = new ArrayList<Object>();
        for (DependencyDescription description : instantiation.getDependencies()) {
            Object object = this.objects.get(description.getType());
            if (object == null) {
                return null;
            }
            dependencies.add(object);
        }
        return (T)this.runPostConstructHandlers(instantiation.instantiateWith(dependencies.toArray()));
    }

    @Override
    public <T> Collection<T> retrieveAllOfType(Class<T> clazz) {
        ArrayList<T> instances = new ArrayList<T>();
        for (Object object : this.objects.values()) {
            if (!clazz.isInstance(object)) continue;
            instances.add(clazz.cast(object));
        }
        return instances;
    }

    @Override
    public <T> void registerProvider(Class<T> clazz, Provider<? extends T> provider) {
        InjectorUtils.checkNotNull(clazz, "Class may not be null");
        InjectorUtils.checkNotNull(provider, "Provider may not be null");
        for (ProviderHandler handler : this.config.getProviderHandlers()) {
            try {
                handler.onProvider(clazz, provider);
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
    }

    @Override
    public <T, P extends Provider<? extends T>> void registerProvider(Class<T> clazz, Class<P> providerClass) {
        InjectorUtils.checkNotNull(clazz, "Class may not be null");
        InjectorUtils.checkNotNull(providerClass, "Provider class may not be null");
        for (ProviderHandler handler : this.config.getProviderHandlers()) {
            try {
                handler.onProviderClass(clazz, providerClass);
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
    }

    public InjectorConfig getConfig() {
        return this.config;
    }

    private <T, U extends T> T get(Class<T> clazz, Set<Class<?>> traversedClasses) {
        if (this.objects.containsKey(clazz)) {
            return clazz.cast(this.objects.get(clazz));
        }
        Class<U> mappedClass = this.processPreConstructorHandlers(clazz);
        traversedClasses = new HashSet(traversedClasses);
        traversedClasses.add(mappedClass);
        U object = this.instantiate(mappedClass, traversedClasses);
        this.register(clazz, object);
        if (mappedClass != clazz) {
            this.register(mappedClass, object);
        }
        return (T)object;
    }

    private <T> T instantiate(Class<T> clazz, Set<Class<?>> traversedClasses) {
        Instantiation<T> instantiation = this.getInstantiation(clazz);
        InjectorImpl.validateInjectionHasNoCircularDependencies(instantiation.getDependencies(), traversedClasses);
        Object[] dependencies = this.resolveDependencies(instantiation, traversedClasses);
        T object = instantiation.instantiateWith(dependencies);
        return this.runPostConstructHandlers(object);
    }

    private <T> Instantiation<T> getInstantiation(Class<T> clazz) {
        for (InstantiationProvider provider : this.config.getInstantiationProviders()) {
            Instantiation<T> instantiation = provider.get(clazz);
            if (instantiation == null) continue;
            return instantiation;
        }
        if (this.config.getInstantiationProviders().isEmpty()) {
            throw new InjectorException("You did not register any instantiation methods!");
        }
        if (!InjectorUtils.canInstantiate(clazz)) {
            throw new InjectorException("Did not find instantiation method for '" + clazz + "'. This class cannot " + "be instantiated directly, please check the class or your handlers.");
        }
        throw new InjectorException("Did not find instantiation method for '" + clazz + "'. Make sure your class " + "conforms to one of the registered instantiations. If default: make sure you have " + "a constructor with @Inject or fields with @Inject. Fields with @Inject require " + "the default constructor");
    }

    private Object[] resolveDependencies(Instantiation<?> instantiation, Set<Class<?>> traversedClasses) {
        List<DependencyDescription> dependencies = instantiation.getDependencies();
        Object[] values = new Object[dependencies.size()];
        for (int i = 0; i < dependencies.size(); ++i) {
            DependencyDescription dependency = dependencies.get(i);
            Object object = this.resolveDependency(dependency);
            values[i] = object == null ? this.get(dependency.getType(), traversedClasses) : object;
        }
        return values;
    }

    private <T, U extends T> Class<U> processPreConstructorHandlers(Class<T> clazz) {
        Class<T> mappedClass = clazz;
        for (PreConstructHandler preConstructHandler : this.config.getPreConstructHandlers()) {
            try {
                mappedClass = InjectorUtils.firstNotNull(preConstructHandler.accept(mappedClass), mappedClass);
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
        return mappedClass;
    }

    private <T> T runPostConstructHandlers(T instance) {
        T object = instance;
        for (PostConstructHandler postConstructHandler : this.config.getPostConstructHandlers()) {
            try {
                object = InjectorUtils.firstNotNull(postConstructHandler.process(object), object);
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
        return object;
    }

    @Nullable
    private Object resolveDependency(DependencyDescription dependencyDescription) {
        for (DependencyHandler handler : this.config.getDependencyHandlers()) {
            try {
                Object o = handler.resolveValue(this, dependencyDescription);
                if (o == null) continue;
                return o;
            }
            catch (Exception e) {
                InjectorUtils.rethrowException(e);
            }
        }
        return null;
    }

    private static void validateInjectionHasNoCircularDependencies(List<? extends DependencyDescription> dependencies, Set<Class<?>> traversedClasses) {
        for (DependencyDescription dependencyDescription : dependencies) {
            Class<?> clazz = dependencyDescription.getType();
            if (!traversedClasses.contains(clazz)) continue;
            throw new InjectorException("Found cyclic dependency - already traversed '" + clazz + "' (full traversal list: " + traversedClasses + ")");
        }
    }
}

