/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapNormalizer {
    private final boolean splitDotPaths;

    public MapNormalizer(boolean splitDotPaths) {
        this.splitDotPaths = splitDotPaths;
    }

    protected final boolean splitDotPaths() {
        return this.splitDotPaths;
    }

    @Nullable
    public Map<String, Object> normalizeMap(@Nullable Map<Object, Object> loadedMap) {
        if (loadedMap == null) {
            return null;
        }
        return this.createNormalizedMapIfNeeded(loadedMap).orElse(loadedMap);
    }

    @NotNull
    protected Optional<Map<String, Object>> createNormalizedMapIfNeeded(@NotNull Object value) {
        if (!(value instanceof Map)) {
            return Optional.empty();
        }
        Map map = (Map)value;
        boolean mapNeedsModification = false;
        for (Map.Entry entry : map.entrySet()) {
            this.createNormalizedMapIfNeeded(entry.getValue()).ifPresent(newMap -> map.put(entry.getKey(), newMap));
            if (mapNeedsModification || !this.isKeyInvalid(entry.getKey())) continue;
            mapNeedsModification = true;
        }
        if (mapNeedsModification) {
            LinkedHashMap<String, Object> cleanedMap = new LinkedHashMap<String, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.addValueIntoMap(cleanedMap, Objects.toString(entry.getKey()), entry.getValue());
            }
            return Optional.of(cleanedMap);
        }
        return Optional.empty();
    }

    protected boolean isKeyInvalid(@NotNull Object key) {
        if (key instanceof String) {
            return this.splitDotPaths && ((String)key).contains(".");
        }
        return true;
    }

    protected void addValueIntoMap(@NotNull Map<String, Object> map, @NotNull String path, @NotNull Object value) {
        int dotPosition;
        int n = dotPosition = this.splitDotPaths ? path.indexOf(".") : -1;
        if (dotPosition > -1) {
            String pathElement = path.substring(0, dotPosition);
            Map<String, Object> mapAtPath = this.getOrInsertMap(map, pathElement);
            this.addValueIntoMap(mapAtPath, path.substring(dotPosition + 1), value);
        } else if (value instanceof Map) {
            Map<String, Object> mapAtPath = this.getOrInsertMap(map, path);
            Map mapValue = (Map)value;
            mapValue.forEach((entryKey, entryValue) -> this.addValueIntoMap(mapAtPath, Objects.toString(entryKey), entryValue));
        } else {
            map.put(path, value);
        }
    }

    @NotNull
    protected Map<String, Object> getOrInsertMap(@NotNull Map<String, Object> parentMap, @NotNull String path) {
        Object value = parentMap.get(path);
        if (value instanceof Map) {
            return (Map)value;
        }
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        parentMap.put(path, newMap);
        return newMap;
    }
}

