/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumPropertyType<E extends Enum<E>>
implements PropertyType<E> {
    private Class<E> enumType;

    public EnumPropertyType(@NotNull Class<E> enumType) {
        this.enumType = enumType;
    }

    @NotNull
    public static <E extends Enum<E>> EnumPropertyType<E> of(@NotNull Class<E> type) {
        return new EnumPropertyType<E>(type);
    }

    @Override
    @Nullable
    public E convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (this.enumType.isInstance(object)) {
            return (E)((Enum)object);
        }
        if (!(object instanceof String)) {
            return null;
        }
        String name = (String)object;
        for (Enum entry : (Enum[])this.enumType.getEnumConstants()) {
            if (!entry.name().equalsIgnoreCase(name)) continue;
            return (E)entry;
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(@NotNull E value) {
        return ((Enum)value).name();
    }
}

