/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.ArrayProperty;
import ch.jalu.configme.properties.InlineArrayProperty;
import ch.jalu.configme.properties.ListProperty;
import ch.jalu.configme.properties.MapProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.inlinearray.InlineArrayConverter;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyBuilder<K, T, B extends PropertyBuilder<K, T, B>> {
    private String path;
    private T defaultValue;
    private final PropertyType<K> type;

    public PropertyBuilder(@Nullable PropertyType<K> type) {
        this.type = type;
    }

    @NotNull
    public B path(@NotNull String path) {
        this.path = path;
        return (B)this;
    }

    @NotNull
    public B defaultValue(@NotNull T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    @NotNull
    public abstract Property<T> build();

    @Nullable
    protected final String getPath() {
        return this.path;
    }

    @Nullable
    protected final T getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    protected final PropertyType<K> getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface CreateFunction<K, T> {
        @NotNull
        public Property<T> apply(@NotNull String var1, @NotNull T var2, @NotNull PropertyType<K> var3);
    }

    public static class SetPropertyBuilder<T>
    extends PropertyBuilder<T, Set<T>, SetPropertyBuilder<T>> {
        public SetPropertyBuilder(@NotNull PropertyType<T> type) {
            super(type);
        }

        @Override
        @NotNull
        public SetPropertyBuilder<T> defaultValue(T ... defaultValue) {
            Set defaultSet = Arrays.stream(defaultValue).collect(Collectors.toCollection(LinkedHashSet::new));
            return (SetPropertyBuilder)super.defaultValue(defaultSet);
        }

        @Override
        @NotNull
        public Property<Set<T>> build() {
            return new SetProperty(this.getPath(), this.getType(), (Set)this.getDefaultValue());
        }
    }

    public static class ListPropertyBuilder<T>
    extends PropertyBuilder<T, List<T>, ListPropertyBuilder<T>> {
        public ListPropertyBuilder(@NotNull PropertyType<T> type) {
            super(type);
        }

        @Override
        @NotNull
        public ListPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (ListPropertyBuilder)super.defaultValue(Arrays.asList(defaultValue));
        }

        @Override
        @NotNull
        public Property<List<T>> build() {
            return new ListProperty(this.getPath(), this.getType(), (List)this.getDefaultValue());
        }
    }

    public static class InlineArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], InlineArrayPropertyBuilder<T>> {
        private InlineArrayConverter<T> inlineConverter;

        public InlineArrayPropertyBuilder(@NotNull InlineArrayConverter<T> inlineConverter) {
            super(null);
            this.inlineConverter = inlineConverter;
        }

        @Override
        @NotNull
        public InlineArrayPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (InlineArrayPropertyBuilder)super.defaultValue(defaultValue);
        }

        @Override
        @NotNull
        public Property<T[]> build() {
            return new InlineArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.inlineConverter);
        }
    }

    public static class ArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], ArrayPropertyBuilder<T>> {
        private final IntFunction<T[]> arrayProducer;

        public ArrayPropertyBuilder(@NotNull PropertyType<T> type, @NotNull IntFunction<T[]> arrayProducer) {
            super(type);
            this.arrayProducer = arrayProducer;
        }

        @Override
        @NotNull
        public ArrayPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (ArrayPropertyBuilder)super.defaultValue(defaultValue);
        }

        @Override
        @NotNull
        public Property<T[]> build() {
            return new ArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.getType(), this.arrayProducer);
        }
    }

    public static class TypeBasedPropertyBuilder<T>
    extends PropertyBuilder<T, T, TypeBasedPropertyBuilder<T>> {
        private CreateFunction<T, T> createFunction = TypeBasedProperty::new;

        public TypeBasedPropertyBuilder(@NotNull PropertyType<T> type) {
            super(type);
        }

        @NotNull
        public TypeBasedPropertyBuilder<T> createFunction(@NotNull CreateFunction<T, T> createFunction) {
            this.createFunction = createFunction;
            return this;
        }

        @Override
        @NotNull
        public Property<T> build() {
            return this.createFunction.apply(this.getPath(), this.getDefaultValue(), this.getType());
        }
    }

    public static class MapPropertyBuilder<T>
    extends PropertyBuilder<T, Map<String, T>, MapPropertyBuilder<T>> {
        public MapPropertyBuilder(@NotNull PropertyType<T> type) {
            super(type);
            this.defaultValue(new LinkedHashMap());
        }

        @NotNull
        public MapPropertyBuilder<T> defaultEntry(@NotNull String key, @NotNull T value) {
            ((Map)this.getDefaultValue()).put(key, value);
            return this;
        }

        @Override
        @NotNull
        public MapProperty<T> build() {
            return new MapProperty(this.getPath(), (Map)this.getDefaultValue(), this.getType());
        }
    }
}

