package ch.jalu.configme.properties;

import ch.jalu.configme.properties.types.EnumPropertyType;
import org.jetbrains.annotations.NotNull;

/**
 * Enum property.
 *
 * @param <E> the enum type
 */
public class EnumProperty<E extends Enum<E>> extends TypeBasedProperty<E> {

    public EnumProperty(@NotNull Class<E> clazz, @NotNull String path, @NotNull E defaultValue) {
        super(path, defaultValue, EnumPropertyType.of(clazz));
    }
}
