/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.inlinearray.InlineArrayConverter;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineArrayProperty<T>
extends BaseProperty<T[]> {
    private final InlineArrayConverter<T> inlineConverter;

    public InlineArrayProperty(@NotNull String path, T @NotNull [] defaultValue, @NotNull InlineArrayConverter<T> inlineConverter) {
        super(path, defaultValue);
        Objects.requireNonNull(inlineConverter, "inlineConverter");
        this.inlineConverter = inlineConverter;
    }

    @Override
    protected T @Nullable [] getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        String value = reader.getString(this.getPath());
        return value == null ? null : this.inlineConverter.fromString(value);
    }

    @Override
    public Object toExportValue(T @NotNull [] value) {
        return this.inlineConverter.toExportValue(value);
    }
}

