/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.configurationdata;

import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropertyListBuilder {
    @NotNull
    private Map<String, Object> rootEntries = new LinkedHashMap<String, Object>();

    public void add(@NotNull Property<?> property) {
        String[] paths = property.getPath().split("\\.");
        Map<String, Object> map = this.rootEntries;
        for (int i = 0; i < paths.length - 1; ++i) {
            map = PropertyListBuilder.getChildMap(map, paths[i]);
        }
        String end = paths[paths.length - 1];
        if (map.containsKey(end)) {
            throw new ConfigMeException("Path at '" + property.getPath() + "' already exists");
        }
        map.put(end, property);
    }

    @NotNull
    public List<Property<?>> create() {
        ArrayList result = new ArrayList();
        PropertyListBuilder.collectEntries(this.rootEntries, result);
        return result;
    }

    @NotNull
    protected final Map<String, Object> getRootEntries() {
        return this.rootEntries;
    }

    @NotNull
    private static Map<String, Object> getChildMap(@NotNull Map<String, Object> parent, @NotNull String path) {
        Object o = parent.get(path);
        if (o instanceof Map) {
            return PropertyListBuilder.asTypedMap(o);
        }
        if (o == null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            parent.put(path, map);
            return map;
        }
        if (o instanceof Property) {
            throw new ConfigMeException("Unexpected entry found at path '" + path + "'");
        }
        throw new ConfigMeException("Value of unknown type found at '" + path + "': " + o);
    }

    private static void collectEntries(@NotNull Map<String, Object> map, @NotNull List<Property<?>> results) {
        for (Object o : map.values()) {
            if (o instanceof Map) {
                PropertyListBuilder.collectEntries(PropertyListBuilder.asTypedMap(o), results);
                continue;
            }
            if (!(o instanceof Property)) continue;
            results.add((Property)o);
        }
    }

    @NotNull
    private static Map<String, Object> asTypedMap(@NotNull Object o) {
        return (Map)o;
    }
}

