/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.beanmapper.MappingContext;
import ch.jalu.configme.beanmapper.MappingContextImpl;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.StandardLeafValueHandlers;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactoryImpl;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyComments;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.convertresult.ValueWithComments;
import ch.jalu.configme.utils.TypeInformation;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapperImpl
implements Mapper {
    public static final Object RETURN_NULL = new Object();
    private final BeanDescriptionFactory beanDescriptionFactory;
    private final LeafValueHandler leafValueHandler;

    public MapperImpl() {
        this(new BeanDescriptionFactoryImpl(), StandardLeafValueHandlers.getDefaultLeafValueHandler());
    }

    public MapperImpl(@NotNull BeanDescriptionFactory beanDescriptionFactory, @NotNull LeafValueHandler leafValueHandler) {
        this.beanDescriptionFactory = beanDescriptionFactory;
        this.leafValueHandler = leafValueHandler;
    }

    @NotNull
    protected final BeanDescriptionFactory getBeanDescriptionFactory() {
        return this.beanDescriptionFactory;
    }

    @NotNull
    protected final LeafValueHandler getLeafValueHandler() {
        return this.leafValueHandler;
    }

    @NotNull
    protected MappingContext createRootMappingContext(@NotNull TypeInformation beanType, @NotNull ConvertErrorRecorder errorRecorder) {
        return MappingContextImpl.createRoot(beanType, errorRecorder);
    }

    @Override
    @Nullable
    public Object toExportValue(@Nullable Object value) {
        return this.toExportValue(value, new HashSet<UUID>());
    }

    @Nullable
    protected Object toExportValue(@Nullable Object value, @NotNull Set<UUID> knownUniqueComments) {
        Object simpleValue = this.leafValueHandler.toExportValue(value);
        if (simpleValue != null || value == null) {
            return MapperImpl.unwrapReturnNull(simpleValue);
        }
        simpleValue = this.createExportValueForSpecialTypes(value, knownUniqueComments);
        if (simpleValue != null) {
            return MapperImpl.unwrapReturnNull(simpleValue);
        }
        LinkedHashMap<String, Object> mappedBean = new LinkedHashMap<String, Object>();
        for (BeanPropertyDescription property : this.beanDescriptionFactory.getAllProperties(value.getClass())) {
            Object exportValueOfProperty = this.toExportValue(property.getValue(value), knownUniqueComments);
            if (exportValueOfProperty == null) continue;
            BeanPropertyComments propComments = property.getComments();
            if (!(propComments.getComments().isEmpty() || propComments.getUuid() != null && knownUniqueComments.contains(propComments.getUuid()))) {
                knownUniqueComments.add(propComments.getUuid());
                exportValueOfProperty = new ValueWithComments(exportValueOfProperty, propComments.getComments());
            }
            mappedBean.put(property.getName(), exportValueOfProperty);
        }
        return mappedBean;
    }

    @Nullable
    protected Object createExportValueForSpecialTypes(@Nullable Object value, @NotNull Set<UUID> knownUniqueComments) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(entry -> this.toExportValue(entry, knownUniqueComments)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry2 : ((Map)value).entrySet()) {
                result.put(entry2.getKey(), this.toExportValue(entry2.getValue(), knownUniqueComments));
            }
            return result;
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.map(v -> this.toExportValue(v, knownUniqueComments)).orElse(RETURN_NULL);
        }
        return null;
    }

    @Nullable
    protected static Object unwrapReturnNull(@Nullable Object o) {
        return o == RETURN_NULL ? null : o;
    }

    @Override
    @Nullable
    public Object convertToBean(@Nullable Object value, @NotNull TypeInformation beanType, @NotNull ConvertErrorRecorder errorRecorder) {
        if (value == null) {
            return null;
        }
        return this.convertValueForType(this.createRootMappingContext(beanType, errorRecorder), value);
    }

    @Nullable
    protected Object convertValueForType(@NotNull MappingContext context, @Nullable Object value) {
        Class<?> rawClass = context.getTypeInformation().getSafeToWriteClass();
        if (rawClass == null) {
            throw new ConfigMeMapperException(context, "Cannot determine required type");
        }
        Object result = this.leafValueHandler.convert(context.getTypeInformation(), value);
        if (result != null) {
            return result;
        }
        result = this.handleSpecialTypes(context, value);
        if (result != null) {
            return result;
        }
        return this.createBean(context, value);
    }

    @Nullable
    protected Object handleSpecialTypes(@NotNull MappingContext context, @Nullable Object value) {
        Class<?> rawClass = context.getTypeInformation().getSafeToWriteClass();
        if (Collection.class.isAssignableFrom(rawClass)) {
            return this.createCollection(context, value);
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            return this.createMap(context, value);
        }
        if (Optional.class.isAssignableFrom(rawClass)) {
            return this.createOptional(context, value);
        }
        return null;
    }

    @Nullable
    protected Collection createCollection(@NotNull MappingContext context, @Nullable Object value) {
        if (value instanceof Iterable) {
            TypeInformation entryType = context.getGenericTypeInfoOrFail(0);
            Collection result = this.createCollectionMatchingType(context);
            int index = 0;
            for (Object entry : (Iterable)value) {
                Object convertedEntry = this.convertValueForType(context.createChild("[" + index + "]", entryType), entry);
                if (convertedEntry == null) {
                    context.registerError("Cannot convert value at index " + index);
                    continue;
                }
                result.add(convertedEntry);
            }
            return result;
        }
        return null;
    }

    @NotNull
    protected Collection createCollectionMatchingType(@NotNull MappingContext mappingContext) {
        Class<AbstractCollection> collectionType = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (collectionType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported collection type '" + collectionType + "'");
    }

    @Nullable
    protected Map createMap(@NotNull MappingContext context, @Nullable Object value) {
        if (value instanceof Map) {
            if (context.getGenericTypeInfoOrFail(0).getSafeToWriteClass() != String.class) {
                throw new ConfigMeMapperException(context, "The key type of maps may only be of String type");
            }
            TypeInformation mapValueType = context.getGenericTypeInfoOrFail(1);
            Map entries = (Map)value;
            Map result = this.createMapMatchingType(context);
            for (Map.Entry entry : entries.entrySet()) {
                Object mappedValue = this.convertValueForType(context.createChild("[k=" + (String)entry.getKey() + "]", mapValueType), entry.getValue());
                if (mappedValue == null) {
                    context.registerError("Cannot map value for key " + (String)entry.getKey());
                    continue;
                }
                result.put(entry.getKey(), mappedValue);
            }
            return result;
        }
        return null;
    }

    @NotNull
    protected Map createMapMatchingType(@NotNull MappingContext mappingContext) {
        Class<AbstractMap> mapType = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (mapType.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap();
        }
        if (mapType.isAssignableFrom(TreeMap.class)) {
            return new TreeMap();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported map type '" + mapType + "'");
    }

    @NotNull
    protected Object createOptional(@NotNull MappingContext context, @Nullable Object value) {
        MappingContext childContext = context.createChild("[v]", context.getGenericTypeInfoOrFail(0));
        Object result = this.convertValueForType(childContext, value);
        return Optional.ofNullable(result);
    }

    @Nullable
    protected Object createBean(@NotNull MappingContext context, @Nullable Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Collection<BeanPropertyDescription> properties = this.beanDescriptionFactory.getAllProperties(context.getTypeInformation().getSafeToWriteClass());
        if (properties.isEmpty()) {
            return null;
        }
        Map entries = (Map)value;
        Object bean = this.createBeanMatchingType(context);
        for (BeanPropertyDescription property : properties) {
            Object result = this.convertValueForType(context.createChild(property.getName(), property.getTypeInformation()), entries.get(property.getName()));
            if (result == null) {
                if (property.getValue(bean) == null) {
                    return null;
                }
                context.registerError("No value found, fallback to field default value");
                continue;
            }
            property.setValue(bean, result);
        }
        return bean;
    }

    @NotNull
    protected Object createBeanMatchingType(@NotNull MappingContext mappingContext) {
        Class<?> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMeMapperException(mappingContext, "Could not create object of type '" + clazz.getName() + "'. It is required to have a default constructor", e);
        }
    }
}

