/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.resource.PropertyReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexProperty
extends BaseProperty<Pattern> {
    public RegexProperty(String path, Pattern defaultValue) {
        super(path, defaultValue);
    }

    public RegexProperty(String path, String defaultRegexValue) {
        this(path, Pattern.compile(defaultRegexValue));
    }

    @Override
    protected Pattern getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
        String pattern = reader.getString(this.getPath());
        if (pattern != null) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object toExportValue(Pattern value) {
        return value.pattern();
    }

    public boolean matches(String value, SettingsManager settingsManager) {
        Matcher matcher = settingsManager.getProperty(this).matcher(value);
        return matcher.matches();
    }
}

