/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ListProperty<T>
extends BaseProperty<List<T>> {
    private final PropertyType<T> type;

    @SafeVarargs
    public ListProperty(String path, PropertyType<T> type, T ... defaultValue) {
        this(path, type, Arrays.asList(defaultValue));
    }

    public ListProperty(String path, PropertyType<T> type, List<T> defaultValue) {
        super(path, Collections.unmodifiableList(defaultValue));
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    @Nullable
    protected List<T> getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
        List<?> list = reader.getList(this.getPath());
        if (list != null) {
            return Collections.unmodifiableList(list.stream().map(elem -> this.type.convert(elem, errorRecorder)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public Object toExportValue(List<T> value) {
        return value.stream().map(this.type::toExportValue).collect(Collectors.toList());
    }
}

