/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.MappingContext;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.utils.TypeInformation;

public class MappingContextImpl
implements MappingContext {
    private final String path;
    private final TypeInformation typeInformation;
    private final ConvertErrorRecorder errorRecorder;

    protected MappingContextImpl(String path, TypeInformation typeInformation, ConvertErrorRecorder errorRecorder) {
        this.path = path;
        this.typeInformation = typeInformation;
        this.errorRecorder = errorRecorder;
    }

    public static MappingContextImpl createRoot(TypeInformation typeInformation, ConvertErrorRecorder errorRecorder) {
        return new MappingContextImpl("", typeInformation, errorRecorder);
    }

    @Override
    public MappingContext createChild(String subPath, TypeInformation typeInformation) {
        if (this.path.isEmpty()) {
            return new MappingContextImpl(subPath, typeInformation, this.errorRecorder);
        }
        return new MappingContextImpl(this.path + "." + subPath, typeInformation, this.errorRecorder);
    }

    @Override
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public String createDescription() {
        return "Path: '" + this.path + "', type: '" + this.typeInformation.getType() + "'";
    }

    @Override
    public void registerError(String reason) {
        this.errorRecorder.setHasError("At path '" + this.path + "': " + reason);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.createDescription() + "]";
    }
}

