/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyPathTraverser;
import ch.jalu.configme.resource.PropertyReader;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileReader;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private final Path path;
    private final YamlFileResourceOptions options;
    private final String indentationSpace;
    private Yaml yamlObject;

    public YamlFileResource(Path path) {
        this(path, YamlFileResourceOptions.builder().build());
    }

    public YamlFileResource(Path path, YamlFileResourceOptions options) {
        this.path = path;
        this.options = options;
        this.indentationSpace = String.join((CharSequence)"", Collections.nCopies(options.getIndentationSize(), " "));
    }

    @Deprecated
    public YamlFileResource(File file) {
        this(file.toPath());
    }

    @Override
    public PropertyReader createReader() {
        return new YamlFileReader(this.path, this.options.getCharset());
    }

    @Override
    public void exportProperties(ConfigurationData configurationData) {
        try (OutputStream os = Files.newOutputStream(this.path, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(os, this.options.getCharset());){
            PropertyPathTraverser pathTraverser = new PropertyPathTraverser(configurationData);
            for (Property<?> property : configurationData.getProperties()) {
                Object exportValue = this.getExportValue(property, configurationData);
                this.exportValue(writer, pathTraverser, property.getPath(), exportValue);
            }
            writer.append("\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + this.path + "'", e);
        }
        finally {
            this.onWriteComplete();
        }
    }

    protected final Path getPath() {
        return this.path;
    }

    @Deprecated
    protected final File getFile() {
        return this.path.toFile();
    }

    protected void exportValue(Writer writer, PropertyPathTraverser pathTraverser, String path, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Map && !((Map)value).isEmpty()) {
            String pathPrefix = path.isEmpty() ? "" : path + ".";
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.exportValue(writer, pathTraverser, pathPrefix + (String)entry.getKey(), entry.getValue());
            }
        } else {
            List<PropertyPathTraverser.PathElement> pathElements = pathTraverser.getPathElements(path);
            for (PropertyPathTraverser.PathElement pathElement : pathElements) {
                this.writeIndentingBetweenLines(writer, pathElement);
                this.writeComments(writer, pathElement.getIndentationLevel(), pathElement);
                writer.append(this.getNewLineIfNotFirstElement(pathElement)).append(this.indent(pathElement.getIndentationLevel())).append(this.escapePathElementIfNeeded(pathElement.getName())).append(":");
            }
            writer.append(" ").append(this.toYamlIndented(value, pathElements.get(pathElements.size() - 1).getIndentationLevel()));
        }
    }

    protected void writeComments(Writer writer, int indentation, PropertyPathTraverser.PathElement pathElement) throws IOException {
        if (pathElement.getComments().isEmpty()) {
            return;
        }
        String lineStart = pathElement.isFirstElement() ? "" : "\n";
        String commentStart = this.indent(indentation) + "# ";
        for (String comment : pathElement.getComments()) {
            writer.append(lineStart);
            lineStart = "\n";
            if ("\n".equals(comment)) continue;
            writer.append(commentStart).append(comment);
        }
    }

    private void writeIndentingBetweenLines(Writer writer, PropertyPathTraverser.PathElement pathElement) throws IOException {
        int numberOfEmptyLines = this.options.getNumberOfEmptyLinesBefore(pathElement);
        for (int i = 0; i < numberOfEmptyLines; ++i) {
            writer.append("\n");
        }
    }

    private String getNewLineIfNotFirstElement(PropertyPathTraverser.PathElement pathElement) {
        return pathElement.isFirstElement() && pathElement.getComments().isEmpty() ? "" : "\n";
    }

    protected String toYamlIndented(@Nullable Object value, int indent) {
        String representation = this.toYaml(value);
        CharSequence[] lines = representation.split("\\n");
        return String.join((CharSequence)("\n" + this.indent(indent)), lines);
    }

    protected String toYaml(@Nullable Object value) {
        if (value instanceof String) {
            return this.getYamlObject().dump(value);
        }
        if (value instanceof Collection) {
            List<?> list = YamlFileResource.collectionToList((Collection)value);
            return list.isEmpty() ? "[]" : "\n" + this.getYamlObject().dump(list);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return array.length == 0 ? "[]" : "\n" + this.getYamlObject().dump((Object)array);
        }
        return this.getYamlObject().dump(value);
    }

    protected String indent(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append(this.indentationSpace);
        }
        return result.toString();
    }

    protected String escapePathElementIfNeeded(String path) {
        return this.getYamlObject().dump((Object)path).trim();
    }

    protected void onWriteComplete() {
        this.yamlObject = null;
    }

    protected Yaml getYamlObject() {
        if (this.yamlObject == null) {
            this.yamlObject = this.createNewYaml();
        }
        return this.yamlObject;
    }

    protected Yaml createNewYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        return new Yaml(options);
    }

    protected final YamlFileResourceOptions getOptions() {
        return this.options;
    }

    private <T> Object getExportValue(Property<T> property, ConfigurationData configurationData) {
        return property.toExportValue(configurationData.getValue(property));
    }

    private static List<?> collectionToList(Collection<?> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList(collection);
    }
}

