/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class MapNormalizer {
    public Map<String, Object> normalizeMap(@Nullable Map<Object, Object> loadedMap) {
        if (loadedMap == null) {
            return Collections.emptyMap();
        }
        return this.createNormalizedMapIfNeeded(loadedMap).orElse(loadedMap);
    }

    protected Optional<Map<String, Object>> createNormalizedMapIfNeeded(Object value) {
        if (!(value instanceof Map)) {
            return Optional.empty();
        }
        Map map = (Map)value;
        boolean mapNeedsModification = false;
        for (Map.Entry entry : map.entrySet()) {
            this.createNormalizedMapIfNeeded(entry.getValue()).ifPresent(newMap -> map.put(entry.getKey(), newMap));
            if (mapNeedsModification || !this.isKeyInvalid(entry.getKey())) continue;
            mapNeedsModification = true;
        }
        if (mapNeedsModification) {
            LinkedHashMap<String, Object> cleanedMap = new LinkedHashMap<String, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.addValueIntoMap(cleanedMap, Objects.toString(entry.getKey()), entry.getValue());
            }
            return Optional.of(cleanedMap);
        }
        return Optional.empty();
    }

    protected boolean isKeyInvalid(Object key) {
        return !(key instanceof String) || ((String)key).contains(".");
    }

    protected void addValueIntoMap(Map<String, Object> map, String path, Object value) {
        int dotPosition = path.indexOf(".");
        if (dotPosition > -1) {
            String pathElement = path.substring(0, dotPosition);
            Map<String, Object> mapAtPath = this.getOrInsertMap(map, pathElement);
            this.addValueIntoMap(mapAtPath, path.substring(dotPosition + 1), value);
        } else if (value instanceof Map) {
            Map<String, Object> mapAtPath = this.getOrInsertMap(map, path);
            Map mapValue = (Map)value;
            mapValue.forEach((entryKey, entryValue) -> this.addValueIntoMap(mapAtPath, Objects.toString(entryKey), entryValue));
        } else {
            map.put(path, value);
        }
    }

    protected Map<String, Object> getOrInsertMap(Map<String, Object> parentMap, String path) {
        Object value = parentMap.get(path);
        if (value instanceof Map) {
            return (Map)value;
        }
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        parentMap.put(path, newMap);
        return newMap;
    }
}

