/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.ArrayProperty;
import ch.jalu.configme.properties.InlineArrayProperty;
import ch.jalu.configme.properties.ListProperty;
import ch.jalu.configme.properties.MapProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.SetProperty;
import ch.jalu.configme.properties.TypeBasedProperty;
import ch.jalu.configme.properties.inlinearray.InlineArrayConverter;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public abstract class PropertyBuilder<K, T, B extends PropertyBuilder<K, T, B>> {
    private String path;
    private T defaultValue;
    private PropertyType<K> type;

    public PropertyBuilder(PropertyType<K> type) {
        this.type = type;
    }

    public B path(String path) {
        this.path = path;
        return (B)this;
    }

    public B defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    public abstract Property<T> build();

    protected final String getPath() {
        return this.path;
    }

    protected final T getDefaultValue() {
        return this.defaultValue;
    }

    protected final PropertyType<K> getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface CreateFunction<K, T> {
        public Property<T> apply(String var1, T var2, PropertyType<K> var3);
    }

    public static class SetPropertyBuilder<T>
    extends PropertyBuilder<T, Set<T>, SetPropertyBuilder<T>> {
        public SetPropertyBuilder(PropertyType<T> type) {
            super(type);
        }

        @Override
        public SetPropertyBuilder<T> defaultValue(T ... defaultValue) {
            Set defaultSet = Arrays.stream(defaultValue).collect(Collectors.toCollection(LinkedHashSet::new));
            return (SetPropertyBuilder)super.defaultValue(defaultSet);
        }

        @Override
        public Property<Set<T>> build() {
            return new SetProperty(this.getPath(), this.getType(), (Set)this.getDefaultValue());
        }
    }

    public static class ListPropertyBuilder<T>
    extends PropertyBuilder<T, List<T>, ListPropertyBuilder<T>> {
        public ListPropertyBuilder(PropertyType<T> type) {
            super(type);
        }

        @Override
        public ListPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (ListPropertyBuilder)super.defaultValue(Arrays.asList(defaultValue));
        }

        @Override
        public Property<List<T>> build() {
            return new ListProperty(this.getPath(), this.getType(), (List)this.getDefaultValue());
        }
    }

    public static class InlineArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], InlineArrayPropertyBuilder<T>> {
        private InlineArrayConverter<T> inlineConverter;

        public InlineArrayPropertyBuilder(InlineArrayConverter<T> inlineConverter) {
            super(null);
            this.inlineConverter = inlineConverter;
        }

        @Override
        public InlineArrayPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (InlineArrayPropertyBuilder)super.defaultValue(defaultValue);
        }

        @Override
        public Property<T[]> build() {
            return new InlineArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.inlineConverter);
        }
    }

    public static class ArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], ArrayPropertyBuilder<T>> {
        private final IntFunction<T[]> arrayProducer;

        public ArrayPropertyBuilder(PropertyType<T> type, IntFunction<T[]> arrayProducer) {
            super(type);
            this.arrayProducer = arrayProducer;
        }

        @Override
        public ArrayPropertyBuilder<T> defaultValue(T ... defaultValue) {
            return (ArrayPropertyBuilder)super.defaultValue(defaultValue);
        }

        @Override
        public Property<T[]> build() {
            return new ArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.getType(), this.arrayProducer);
        }
    }

    public static class TypeBasedPropertyBuilder<T>
    extends PropertyBuilder<T, T, TypeBasedPropertyBuilder<T>> {
        private CreateFunction<T, T> createFunction = TypeBasedProperty::new;

        public TypeBasedPropertyBuilder(PropertyType<T> type) {
            super(type);
        }

        public TypeBasedPropertyBuilder<T> createFunction(CreateFunction<T, T> createFunction) {
            this.createFunction = createFunction;
            return this;
        }

        @Override
        public Property<T> build() {
            return this.createFunction.apply(this.getPath(), this.getDefaultValue(), this.getType());
        }
    }

    public static class MapPropertyBuilder<T>
    extends PropertyBuilder<T, Map<String, T>, MapPropertyBuilder<T>> {
        public MapPropertyBuilder(PropertyType<T> type) {
            super(type);
            this.defaultValue(new LinkedHashMap());
        }

        public MapPropertyBuilder<T> defaultEntry(String key, T value) {
            ((Map)this.getDefaultValue()).put(key, value);
            return this;
        }

        @Override
        public MapProperty<T> build() {
            return new MapProperty(this.getPath(), (Map)this.getDefaultValue(), this.getType());
        }
    }
}

