/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.convertresult.PropertyValue;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Optional;

public class OptionalProperty<T>
implements Property<Optional<T>> {
    private final Property<T> baseProperty;
    private final Optional<T> defaultValue;

    public OptionalProperty(Property<T> baseProperty) {
        this.baseProperty = baseProperty;
        this.defaultValue = Optional.empty();
    }

    public OptionalProperty(Property<T> baseProperty, T defaultValue) {
        this.baseProperty = baseProperty;
        this.defaultValue = Optional.of(defaultValue);
    }

    @Override
    public String getPath() {
        return this.baseProperty.getPath();
    }

    @Override
    public PropertyValue<Optional<T>> determineValue(PropertyReader reader) {
        PropertyValue<T> basePropertyValue = this.baseProperty.determineValue(reader);
        Optional value = basePropertyValue.isValidInResource() ? Optional.ofNullable(basePropertyValue.getValue()) : Optional.empty();
        boolean isWrongInResource = !basePropertyValue.isValidInResource() && reader.contains(this.baseProperty.getPath());
        return isWrongInResource ? PropertyValue.withValueRequiringRewrite(value) : PropertyValue.withValidValue(value);
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isValidValue(Optional<T> value) {
        if (value == null) {
            return false;
        }
        return value.map(this.baseProperty::isValidValue).orElse(true);
    }

    @Override
    public Object toExportValue(Optional<T> value) {
        return value.map(this.baseProperty::toExportValue).orElse(null);
    }
}

