/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MapProperty<V>
extends BaseProperty<Map<String, V>> {
    private final PropertyType<V> type;

    public MapProperty(String path, Map<String, V> defaultValue, PropertyType<V> type) {
        super(path, Collections.unmodifiableMap(defaultValue));
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    protected Map<String, V> getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
        Object rawObject = reader.getObject(this.getPath());
        if (!(rawObject instanceof Map)) {
            return null;
        }
        Map rawMap = (Map)rawObject;
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
        for (Map.Entry entry : rawMap.entrySet()) {
            String path = entry.getKey().toString();
            V value = this.type.convert(entry.getValue(), errorRecorder);
            if (value == null) continue;
            map.put(path, value);
        }
        return this.postProcessMap(map);
    }

    @Override
    public Object toExportValue(Map<String, V> value) {
        LinkedHashMap<String, Object> exportMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, V> entry : value.entrySet()) {
            exportMap.put(entry.getKey(), this.type.toExportValue(entry.getValue()));
        }
        return exportMap;
    }

    protected Map<String, V> postProcessMap(Map<String, V> constructedMap) {
        return Collections.unmodifiableMap(constructedMap);
    }
}

