/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.inlinearray.InlineArrayConverter;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Objects;

public class InlineArrayProperty<T>
extends BaseProperty<T[]> {
    private final InlineArrayConverter<T> inlineConverter;

    public InlineArrayProperty(String path, T[] defaultValue, InlineArrayConverter<T> inlineConverter) {
        super(path, defaultValue);
        Objects.requireNonNull(inlineConverter, "inlineConverter");
        this.inlineConverter = inlineConverter;
    }

    @Override
    protected T[] getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
        String value = reader.getString(this.getPath());
        return value == null ? null : this.inlineConverter.fromString(value);
    }

    @Override
    public Object toExportValue(T[] value) {
        return this.inlineConverter.toExportValue(value);
    }
}

