/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.configurationdata;

import ch.jalu.configme.SettingsHolder;
import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.convertresult.PropertyValue;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationDataImpl
implements ConfigurationData {
    private final List<Property<?>> properties;
    private final Map<String, List<String>> allComments;
    private final Map<String, Object> values;
    private boolean allPropertiesValidInResource;

    protected ConfigurationDataImpl(List<? extends Property<?>> allProperties, Map<String, List<String>> allComments) {
        this.properties = Collections.unmodifiableList(allProperties);
        this.allComments = Collections.unmodifiableMap(allComments);
        this.values = new HashMap<String, Object>();
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    public List<String> getCommentsForSection(String path) {
        return this.allComments.getOrDefault(path, Collections.emptyList());
    }

    @Override
    public Map<String, List<String>> getAllComments() {
        return this.allComments;
    }

    @Override
    public <T> T getValue(Property<T> property) {
        Object value = this.values.get(property.getPath());
        if (value == null) {
            throw new ConfigMeException(String.format("No value exists for property with path '%s'. This may happen if the property belongs to a %s class which was not passed to the settings manager.", property.getPath(), SettingsHolder.class.getSimpleName()));
        }
        return (T)value;
    }

    @Override
    public <T> void setValue(Property<T> property, T value) {
        if (!property.isValidValue(value)) {
            throw new ConfigMeException("Invalid value for property '" + property + "': " + value);
        }
        this.values.put(property.getPath(), value);
    }

    @Override
    public void initializeValues(PropertyReader reader) {
        this.values.clear();
        this.allPropertiesValidInResource = this.getProperties().stream().map(property -> this.setValueForProperty((Property)property, reader)).reduce(true, Boolean::logicalAnd);
    }

    protected <T> boolean setValueForProperty(Property<T> property, PropertyReader reader) {
        PropertyValue<T> propertyValue = property.determineValue(reader);
        this.setValue(property, propertyValue.getValue());
        return propertyValue.isValidInResource();
    }

    @Override
    public boolean areAllValuesValidInResource() {
        return this.allPropertiesValidInResource;
    }

    protected Map<String, Object> getValues() {
        return this.values;
    }
}

