/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.properties.types.PropertyType;

public class EnumPropertyType<E extends Enum<E>>
implements PropertyType<E> {
    private Class<E> enumType;

    public EnumPropertyType(Class<E> enumType) {
        this.enumType = enumType;
    }

    public static <E extends Enum<E>> EnumPropertyType<E> of(Class<E> type) {
        return new EnumPropertyType<E>(type);
    }

    @Override
    public E convert(Object object) {
        if (this.enumType.isInstance(object)) {
            return (E)((Enum)object);
        }
        if (!(object instanceof String)) {
            return null;
        }
        String name = (String)object;
        for (Enum entry : (Enum[])this.enumType.getEnumConstants()) {
            if (!entry.name().equalsIgnoreCase(name)) continue;
            return (E)entry;
        }
        return null;
    }

    @Override
    public Object toExportValue(E value) {
        return ((Enum)value).name();
    }
}

