/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.types.PropertyType;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Objects;
import javax.annotation.Nullable;

public class TypeBasedProperty<T>
extends BaseProperty<T> {
    private final PropertyType<T> type;

    public TypeBasedProperty(String path, T defaultValue, PropertyType<T> type) {
        super(path, defaultValue);
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    @Nullable
    protected T getFromReader(PropertyReader reader) {
        return this.type.convert(reader.getObject(this.getPath()));
    }

    @Override
    @Nullable
    public Object toExportValue(T value) {
        return this.type.toExportValue(value);
    }
}

