/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties;

import ch.jalu.configme.properties.BaseProperty;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyReader;
import java.util.Optional;

public class OptionalProperty<T>
extends BaseProperty<Optional<T>> {
    private final Property<T> baseProperty;

    public OptionalProperty(Property<T> baseProperty) {
        super(baseProperty.getPath(), Optional.empty());
        this.baseProperty = baseProperty;
    }

    public OptionalProperty(Property<T> baseProperty, T defaultValue) {
        super(baseProperty.getPath(), Optional.of(defaultValue));
        this.baseProperty = baseProperty;
    }

    @Override
    protected Optional<T> getFromReader(PropertyReader reader) {
        return this.baseProperty.isPresent(reader) ? Optional.ofNullable(this.baseProperty.determineValue(reader)) : Optional.empty();
    }

    @Override
    public boolean isPresent(PropertyReader reader) {
        return true;
    }

    @Override
    public Object toExportValue(Optional<T> value) {
        return value.map(this.baseProperty::toExportValue).orElse(null);
    }
}

